/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.exec;

import java.time.Duration;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.value.OpenUrlStrategy;
import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.RedirectRequestHandlerWithOpenUrlStrategy;
import org.apache.causeway.viewer.wicket.ui.exec.MediatorFactory;
import org.apache.causeway.viewer.wicket.ui.exec.PageRedirectRequest;
import org.apache.causeway.viewer.wicket.ui.pages.obj.DomainObjectPage;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.util.resource.IResourceStream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

record Mediator(ExecutionResultHandlingStrategy handlingStrategy, IRequestHandler handler, PageRedirectRequest<?> pageRedirect, AjaxRequestTarget ajaxTarget, String url) {
    static Mediator toDomainObjectPage(@NonNull ManagedObject entityOrViewmodel) {
        PageRedirectRequest<DomainObjectPage> pageRedirectRequest = PageRedirectRequest.forPageClassAndBookmark(DomainObjectPage.class, (Bookmark)entityOrViewmodel.refreshBookmark().orElseThrow());
        return Mediator.toPage(pageRedirectRequest);
    }

    static Mediator determineAndInterpretResult(ActionModel actionModel, @Nullable AjaxRequestTarget targetIfAny, @Nullable ManagedObject resultAdapter) {
        return MediatorFactory.determineAndInterpretResult(actionModel, targetIfAny, resultAdapter);
    }

    static Mediator withHandler(IRequestHandler handler) {
        return new Mediator(ExecutionResultHandlingStrategy.SCHEDULE_HANDLER, handler, null, null, null);
    }

    static Mediator toPage(PageRedirectRequest<?> page) {
        return new Mediator(ExecutionResultHandlingStrategy.REDIRECT_TO_PAGE, null, page, null, null);
    }

    static Mediator openUrlInBrowser(AjaxRequestTarget ajaxTarget, String url, @NonNull OpenUrlStrategy openUrlStrategy) {
        return new Mediator(openUrlStrategy.isNewWindow() ? ExecutionResultHandlingStrategy.OPEN_URL_IN_NEW_BROWSER_WINDOW : ExecutionResultHandlingStrategy.OPEN_URL_IN_SAME_BROWSER_WINDOW, null, null, ajaxTarget, url);
    }

    void handle() {
        switch (this.handlingStrategy().ordinal()) {
            case 0: {
                MetaModelContext.instance().ifPresent(mmc -> mmc.getTransactionService().flushTransaction());
                this.pageRedirect().apply();
                break;
            }
            case 1: {
                String fullUrl = Mediator.expanded(RequestCycle.get(), this.url());
                Mediator.scheduleJs(this.ajaxTarget(), Mediator.javascriptFor_newWindow(fullUrl), 100);
                break;
            }
            case 2: {
                String fullUrl = Mediator.expanded(RequestCycle.get(), this.url());
                Mediator.scheduleJs(this.ajaxTarget(), Mediator.javascriptFor_sameWindow(fullUrl), 100);
                break;
            }
            case 3: {
                RequestCycle requestCycle = RequestCycle.get();
                AjaxRequestTarget ajaxTarget = requestCycle.find(AjaxRequestTarget.class).orElse(null);
                if (ajaxTarget == null) {
                    requestCycle.scheduleRequestHandlerAfterCurrent(this.handler());
                    break;
                }
                IRequestHandler requestHandler = this.handler();
                if (requestHandler instanceof ResourceStreamRequestHandler) {
                    ResourceStreamRequestHandler scheduledHandler = (ResourceStreamRequestHandler)requestHandler;
                    StreamAfterAjaxResponseBehavior streamingBehavior = new StreamAfterAjaxResponseBehavior(scheduledHandler);
                    Page page = ajaxTarget.getPage();
                    page.add(new Behavior[]{streamingBehavior});
                    CharSequence callbackUrl = streamingBehavior.getCallbackUrl();
                    Mediator.scheduleJs(ajaxTarget, Mediator.javascriptFor_sameWindow(callbackUrl), 10);
                    break;
                }
                if (requestHandler instanceof RedirectRequestHandlerWithOpenUrlStrategy) {
                    RedirectRequestHandlerWithOpenUrlStrategy redirectHandler = (RedirectRequestHandlerWithOpenUrlStrategy)requestHandler;
                    String url = redirectHandler.getRedirectUrl();
                    String fullUrl = Mediator.expanded(requestCycle, url);
                    if (redirectHandler.getOpenUrlStrategy().isNewWindow()) {
                        Mediator.scheduleJs(ajaxTarget, Mediator.javascriptFor_newWindow(fullUrl), 100);
                        break;
                    }
                    Mediator.scheduleJs(ajaxTarget, Mediator.javascriptFor_sameWindow(fullUrl), 100);
                    break;
                }
                throw _Exceptions.unrecoverable((String)"no logic implemented to handle IRequestHandler of type %s", (Object[])new Object[]{requestHandler.getClass().getName()});
            }
        }
    }

    private static String expanded(RequestCycle requestCycle, String url) {
        String urlStr = Mediator.expanded(url);
        return requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlStr));
    }

    private static String expanded(String urlStr) {
        if (urlStr.contains("antiCache=${currentTimeMillis}")) {
            urlStr = urlStr.replace("antiCache=${currentTimeMillis}", "antiCache=" + System.currentTimeMillis());
        }
        return urlStr;
    }

    private static String javascriptFor_newWindow(CharSequence url) {
        return "function(){Wicket.Event.publish(Causeway.Topic.OPEN_IN_NEW_TAB, '" + String.valueOf(url) + "');}";
    }

    private static String javascriptFor_sameWindow(CharSequence url) {
        return "\"window.location.href='" + String.valueOf(url) + "'\"";
    }

    private static void scheduleJs(AjaxRequestTarget target, String js, int millis) {
        target.appendJavaScript((CharSequence)String.format("setTimeout(%s, %d);", js, millis));
    }

    static enum ExecutionResultHandlingStrategy {
        REDIRECT_TO_PAGE,
        OPEN_URL_IN_NEW_BROWSER_WINDOW,
        OPEN_URL_IN_SAME_BROWSER_WINDOW,
        SCHEDULE_HANDLER;

    }

    private static class StreamAfterAjaxResponseBehavior
    extends AbstractAjaxBehavior {
        private static final long serialVersionUID = 1L;
        private final String fileName;
        private final IResourceStream resourceStream;
        private final Duration cacheDuration;

        public StreamAfterAjaxResponseBehavior(ResourceStreamRequestHandler scheduledHandler) {
            this.fileName = scheduledHandler.getFileName();
            this.resourceStream = scheduledHandler.getResourceStream();
            this.cacheDuration = scheduledHandler.getCacheDuration();
        }

        public void onRequest() {
            ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler(this.resourceStream, this.fileName);
            handler.setCacheDuration(this.cacheDuration);
            handler.setContentDisposition(ContentDisposition.ATTACHMENT);
            Component page = this.getComponent();
            page.getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            page.remove(new Behavior[]{this});
        }
    }
}

