/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import org.apache.causeway.applib.fa.FontAwesomeLayers;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.decorators.ActionDecorators;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class WktLinks {
    public static <T extends Page> AbstractLink newBookmarkablePageLink(String linkId, PageParameters pageParameters, Class<T> pageClass) {
        return new BookmarkablePageLink(linkId, pageClass, pageParameters);
    }

    public static AbstractLink asActionLink(Component tooltipReceiver, String titleId, ActionLink link, ActionDecorators.ActionStyle actionStyle) {
        Label actionLabel = Wkt.labelAdd((MarkupContainer)link, titleId, (IModel<String>)((IModel & Serializable)() -> ((ActionLink)link).getFriendlyName()));
        WktDecorators.decorateActionLink((AjaxLink<ManagedObject>)link, tooltipReceiver, actionLabel, ActionDecorators.ActionDecorationModel.builder((HasManagedAction)link).actionStyle(actionStyle).build());
        return link;
    }

    public static <T, R extends MarkupContainer> R listItemAsDropdownLink(@NonNull ListItem<T> item, @NonNull R container, @NonNull String titleId, @NonNull Function<T, IModel<String>> titleProvider, @NonNull String faIconId, @Nullable Function<T, FontAwesomeLayers> faIconCssProvider) {
        Object t = item.getModelObject();
        Wkt.labelAdd(container, titleId, titleProvider.apply(t));
        Wkt.faIconLayersAdd(container, faIconId, Optional.ofNullable(faIconCssProvider).map(iconProv -> (FontAwesomeLayers)iconProv.apply(t)).orElseGet(FontAwesomeLayers::empty));
        return container;
    }

    public static <T, R extends MarkupContainer> R listItemAsDropdownLink(@NonNull ListItem<T> item, @NonNull R container, @NonNull String titleId, @NonNull Function<T, IModel<String>> titleProvider, @NonNull String iconId, @Nullable Function<T, IModel<String>> iconProvider, @Nullable BiFunction<T, Label, IModel<String>> cssFactory) {
        Object t = item.getModelObject();
        Wkt.labelAdd(container, titleId, titleProvider.apply(t));
        Label viewItemIcon = Wkt.labelAdd(container, iconId, (IModel<String>)Optional.ofNullable(iconProvider).map(iconProv -> (IModel)iconProv.apply(t)).orElseGet(() -> Model.of((Serializable)((Object)""))));
        Optional.ofNullable(cssFactory).map(cssFact -> (IModel)cssFact.apply(t, viewItemIcon)).ifPresent(cssModel -> Wkt.cssAppend(viewItemIcon, (IModel<String>)cssModel));
        return container;
    }

    @Generated
    private WktLinks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

