/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.collections._Lists;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.decorators.ActionDecorators;
import org.apache.causeway.viewer.wicket.model.links.Menuable;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.CssSubMenuItemsPanel;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.jspecify.annotations.Nullable;

class CssMenuItem
implements Menuable {
    private static final long serialVersionUID = 1L;
    private static final String ID_MENU_LINK = "menuLink";
    private static final String ID_MENU_LABEL = "menuLabel";
    private static final String ID_SUB_MENU_ITEMS = "subMenuItems";
    private final String name;
    private final ActionLink actionLink;
    private final List<CssMenuItem> subMenuItems = _Lists.newArrayList();
    private CssMenuItem parent;
    private final Menuable.Kind menuableKind;

    public static CssMenuItem newMenuItemWithLink(String name, ActionLink actionLink) {
        return new CssMenuItem(name, Menuable.Kind.LINK, actionLink);
    }

    public static CssMenuItem newMenuItemWithSubmenu(String name) {
        return new CssMenuItem(name, Menuable.Kind.SUBMENU);
    }

    public static CssMenuItem newSpacer() {
        return new CssMenuItem("---", Menuable.Kind.SECTION_SEPARATOR);
    }

    public static CssMenuItem newSectionLabel(String named) {
        return new CssMenuItem(named, Menuable.Kind.SECTION_LABEL);
    }

    public ActionLink actionLinkElseFail() {
        if (this.actionLink == null) {
            throw new NullPointerException("this menu item has no action link");
        }
        return this.actionLink;
    }

    private CssMenuItem(String name, Menuable.Kind menuableKind) {
        this(name, menuableKind, null);
    }

    private CssMenuItem(String name, Menuable.Kind menuableKind, @Nullable ActionLink actionLink) {
        this.name = name;
        this.menuableKind = menuableKind;
        this.actionLink = actionLink;
    }

    protected final void addSubMenuItem(CssMenuItem cssMenuItem) {
        this.subMenuItems.add(cssMenuItem);
    }

    public Can<CssMenuItem> getSubMenuItems() {
        return Can.ofCollection(this.subMenuItems);
    }

    public boolean hasSubMenuItems() {
        return this.subMenuItems.size() > 0;
    }

    void addTo(MarkupContainer markupContainer) {
        Component menuItemComponent = this.addMenuItemComponentTo(markupContainer);
        this.addSubMenuItemComponentsIfAnyTo(markupContainer);
        this.addCssClassAttributesIfRequired(menuItemComponent);
    }

    private Component addMenuItemComponentTo(MarkupContainer markupContainer) {
        Label label = Wkt.labelAdd(markupContainer, ID_MENU_LABEL, (IModel<String>)((IModel & Serializable)this::getName));
        if (this.actionLink != null) {
            markupContainer.add(new Component[]{this.actionLink});
            WktDecorators.decorateMenuAction((AjaxLink<ManagedObject>)this.actionLink, (Component)this.actionLink, label, ActionDecorators.ActionDecorationModel.of((HasManagedAction)this.actionLinkElseFail(), (ActionDecorators.ActionStyle)ActionDecorators.ActionStyle.MENU_ITEM));
            WktComponents.permanentlyHide(markupContainer, ID_MENU_LABEL);
            return this.actionLink;
        }
        WktComponents.permanentlyHide(markupContainer, ID_MENU_LINK);
        label.add(new Behavior[]{new AttributeModifier("class", (IModel)Model.of((Serializable)((Object)"disabled")))});
        return label;
    }

    private void addSubMenuItemComponentsIfAnyTo(MarkupContainer menuItemMarkup) {
        Can<CssMenuItem> subMenuItems = this.getSubMenuItems();
        if (subMenuItems.isEmpty()) {
            WktComponents.permanentlyHide(menuItemMarkup, ID_SUB_MENU_ITEMS);
        } else {
            menuItemMarkup.add(new Component[]{new CssSubMenuItemsPanel(ID_SUB_MENU_ITEMS, subMenuItems)});
        }
    }

    private void addCssClassAttributesIfRequired(Component linkComponent) {
        if (!this.hasSubMenuItems()) {
            return;
        }
        Wkt.cssAppend(linkComponent, this.hasParent() ? "parent" : "top-parent");
    }

    protected void setParent(CssMenuItem parent) {
        this.parent = parent;
        parent.addSubMenuItem((CssMenuItem)_Casts.uncheckedCast((Object)this));
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public CssMenuItem getParent() {
        return this.parent;
    }

    @Generated
    public Menuable.Kind menuableKind() {
        return this.menuableKind;
    }
}

