/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions;

import java.io.Serializable;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.interactions.managed.ManagedAction;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.applib.services.menu.MenuVisitor;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuAction;
import org.apache.causeway.viewer.commons.applib.services.menu.model.MenuDropdown;
import org.apache.causeway.viewer.commons.applib.services.menu.model.NavbarSection;
import org.apache.causeway.viewer.commons.model.action.HasManagedAction;
import org.apache.causeway.viewer.commons.model.decorators.ActionDecorators;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.CssMenuItem;
import org.apache.causeway.viewer.wicket.ui.components.widgets.actionlink.ActionLink;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktDecorators;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.danekja.java.util.function.serializable.SerializableConsumer;

final class ServiceActionUtil {
    static void addLeafItem(CssMenuItem menuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        ActionLink actionLink = menuItem.actionLinkElseFail();
        Label menuItemLabel = Wkt.labelAdd((MarkupContainer)actionLink, "menuLinkLabel", menuItem.getName());
        WktDecorators.decorateMenuAction((AjaxLink<ManagedObject>)actionLink, listItem, menuItemLabel, ActionDecorators.ActionDecorationModel.of((HasManagedAction)actionLink, (ActionDecorators.ActionStyle)ActionDecorators.ActionStyle.MENU_ITEM));
        Fragment leafItem = new Fragment("content", "leafItem", parent);
        leafItem.add(new Component[]{actionLink});
        listItem.add(new Component[]{leafItem});
    }

    static void addFolderItem(CssMenuItem subMenuItem, ListItem<CssMenuItem> listItem, MarkupContainer parent) {
        Wkt.cssAppend(listItem, "dropdown-submenu");
        Fragment folderItem = new Fragment("content", "folderItem", parent);
        listItem.add(new Component[]{folderItem});
        Wkt.labelAdd((MarkupContainer)folderItem, "folderName", (IModel<String>)(IModel & Serializable)() -> subMenuItem.actionLinkElseFail().getFriendlyName());
        Can<CssMenuItem> menuItems = subMenuItem.getSubMenuItems();
        Wkt.listViewAdd((MarkupContainer)folderItem, "subMenuItems", menuItems.toList(), (SerializableConsumer & Serializable)item -> {
            CssMenuItem menuItem = (CssMenuItem)listItem.getModelObject();
            if (menuItem.hasSubMenuItems()) {
                ServiceActionUtil.addFolderItem(menuItem, (ListItem<CssMenuItem>)item, parent);
            } else {
                ServiceActionUtil.addLeafItem(menuItem, (ListItem<CssMenuItem>)item, parent);
            }
        });
    }

    public static void buildMenu(NavbarSection navBarSection, Consumer<CssMenuItem> onNewMenuItem) {
        navBarSection.visitMenuItems((MenuVisitor)MenuBuilderWkt.of(onNewMenuItem));
    }

    @Generated
    private ServiceActionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class MenuBuilderWkt
    implements MenuVisitor {
        private final Consumer<CssMenuItem> onNewMenuItem;
        private CssMenuItem currentTopLevelMenu = null;

        public void onTopLevel(MenuDropdown menuDto) {
            this.currentTopLevelMenu = CssMenuItem.newMenuItemWithSubmenu(menuDto.name());
            this.onNewMenuItem.accept(this.currentTopLevelMenu);
        }

        public void onSectionSpacer() {
            CssMenuItem menuSection = CssMenuItem.newSpacer();
            this.currentTopLevelMenu.addSubMenuItem(menuSection);
        }

        public void onMenuAction(MenuAction menuAction) {
            CssMenuItem menuItem = CssMenuItem.newMenuItemWithLink(menuAction.name(), this.newActionLink((ManagedAction)menuAction.managedAction().orElseThrow()));
            this.currentTopLevelMenu.addSubMenuItem(menuItem);
        }

        public void onSectionLabel(String named) {
            CssMenuItem menuSectionLabel = CssMenuItem.newSectionLabel(named);
            this.currentTopLevelMenu.addSubMenuItem(menuSectionLabel);
        }

        private ActionLink newActionLink(ManagedAction managedAction) {
            UiObjectWkt serviceModel = UiObjectWkt.ofAdapter((ManagedObject)managedAction.getOwner());
            return ActionLink.create(ActionModel.forServiceAction((ObjectAction)managedAction.getAction(), (UiObjectWkt)serviceModel));
        }

        @Generated
        private MenuBuilderWkt(Consumer<CssMenuItem> onNewMenuItem) {
            this.onNewMenuItem = onNewMenuItem;
        }

        @Generated
        public static MenuBuilderWkt of(Consumer<CssMenuItem> onNewMenuItem) {
            return new MenuBuilderWkt(onNewMenuItem);
        }
    }
}

