/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.choices;

import org.apache.causeway.commons.internal.exceptions._Exceptions;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.ObjectChoicesAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.TitleBadgeAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.ValueChoicesAttributePanel;

public class ChoicesSelect2PanelFactory
extends AttributeComponentFactory {
    public ChoicesSelect2PanelFactory() {
        super(AttributePanel.class);
    }

    protected AttributePanel createComponent(String id, UiAttributeWkt attributeModel) {
        ComponentSort componentSort = ComponentSort.valueOf(attributeModel);
        switch (componentSort.ordinal()) {
            case 0: {
                Class valueType = attributeModel.getElementType().getCorrespondingClass();
                return new TitleBadgeAttributePanel(id, attributeModel, valueType);
            }
            case 1: {
                return new ValueChoicesAttributePanel(id, attributeModel);
            }
            case 2: {
                return new ObjectChoicesAttributePanel(id, attributeModel);
            }
        }
        throw _Exceptions.unmatchedCase((Object)((Object)componentSort));
    }

    @Override
    protected ComponentFactory.ApplicationAdvice appliesTo(UiAttributeWkt attributeModel) {
        return ComponentFactory.ApplicationAdvice.APPLIES;
    }

    private static enum ComponentSort {
        TITLE_BADGE,
        VALUE_CHOICES,
        OBJECT_CHOICES;


        static ComponentSort valueOf(UiAttributeWkt attributeModel) {
            if (attributeModel.getElementType().isValue() && attributeModel.getChoiceProviderSort().isChoicesAny()) {
                return attributeModel.isViewingMode() ? TITLE_BADGE : VALUE_CHOICES;
            }
            return OBJECT_CHOICES;
        }
    }
}

