/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.attributes.image;

import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Optional;
import org.apache.causeway.applib.services.placeholder.PlaceholderRenderService;
import org.apache.causeway.viewer.commons.model.components.UiString;
import org.apache.causeway.viewer.wicket.model.models.FileUploadModels;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeFragmentFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributePanelWithFormField;
import org.apache.causeway.viewer.wicket.ui.components.attributes.image.ImagePanel;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;

class ImageAttributePanel
extends AttributePanelWithFormField<BufferedImage> {
    private static final long serialVersionUID = 1L;

    public ImageAttributePanel(String id, UiAttributeWkt attributeModel) {
        super(id, attributeModel, BufferedImage.class);
    }

    protected IModel<List<FileUpload>> fileUploadModel() {
        return FileUploadModels.image((UiAttributeWkt)this.attributeModel());
    }

    @Override
    protected Optional<AttributeFragmentFactory.InputFragment> getInputFragmentType() {
        return Optional.of(AttributeFragmentFactory.InputFragment.FILE);
    }

    @Override
    protected FormComponent createFormComponent(String id, UiAttributeWkt attributeModel) {
        String initialCaption = this.outputFormatAsString();
        FileUploadField fileUploadField = Wkt.fileUploadField(id, initialCaption, this.fileUploadModel());
        this.addAcceptFilterTo((Component)fileUploadField);
        return fileUploadField;
    }

    @Override
    protected UiString obtainOutputFormat() {
        String caption = this.pojoOptional().map(buffImg -> "Image").orElseGet(() -> this.getPlaceholderRenderService().asText(PlaceholderRenderService.PlaceholderLiteral.NULL_REPRESENTATION));
        return UiString.text((String)caption);
    }

    @Override
    protected Component createComponentForOutput(String id) {
        return new ImagePanel(id, this.attributeModel());
    }

    private void addAcceptFilterTo(Component component) {
        Wkt.attributeReplace(component, "accept", this.attributeModel().getFileAccept());
    }

    private Optional<BufferedImage> pojoOptional() {
        return Optional.ofNullable((BufferedImage)this.attributeModel().unwrapAs(this.type));
    }
}

