/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.applib.Identifier;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.config.CausewayConfiguration;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToManyAssociation;
import org.apache.causeway.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.causeway.core.metamodel.tabular.DataTableInteractive;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModelParented;
import org.apache.causeway.viewer.wicket.ui.components.collection.count.CollectionCountProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.CollectionContentsSortableDataProvider;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ActionColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.AssociationColumnAbstract;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.GenericColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.PluralColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.SingularColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.TitleColumn;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ToggleboxColumn;
import org.apache.causeway.viewer.wicket.ui.components.table.CausewayAjaxDataTable;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.filter.FilterToolbar;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

class CollectionContentsAsAjaxTablePanel
extends PanelAbstract<DataTableInteractive, CollectionModel>
implements CollectionCountProvider {
    private static final long serialVersionUID = 1L;
    private static final String ID_TABLE = "table";
    private static final String ID_TABLE_FILTER_BAR = "table-filter-bar";
    private static final CssResourceReference TABLE_CSS = new CssResourceReference(CollectionContentsAsAjaxTablePanel.class, "CollectionContentsAsAjaxTablePanel.css");

    public CollectionContentsAsAjaxTablePanel(String id, CollectionModel model) {
        super(id, model);
    }

    @Override
    public Integer getCount() {
        return ((CollectionModel)this.getModel()).getDataTableModel().getFilteredElementCount();
    }

    protected void onConfigure() {
        super.onConfigure();
        this.buildGui();
        Wkt.ajaxEnable(this);
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)TABLE_CSS));
    }

    protected void onModelChanged() {
    }

    private CollectionModel collectionModel() {
        return (CollectionModel)this.getModel();
    }

    private DataTableInteractive dataTableInteractive() {
        return (DataTableInteractive)this.getModelObject();
    }

    private void buildGui() {
        CollectionModel collectionModel = this.collectionModel();
        if (collectionModel.isHidden()) {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_TABLE);
            WktComponents.permanentlyHide((MarkupContainer)this, ID_TABLE_FILTER_BAR);
            return;
        }
        ObjectSpecification elementType = Objects.requireNonNull(collectionModel.getElementType(), () -> "invalid: CollectionModel without element type");
        ArrayList<GenericColumn> columns = new ArrayList<GenericColumn>();
        this.addPropertyColumnsIfRequired(columns);
        this.prependTitleColumn(elementType, collectionModel.getVariant(), this.getWicketViewerSettings(), columns);
        this.addActionsColumnIfRequired(elementType, columns);
        CollectionContentsSortableDataProvider dataProvider = new CollectionContentsSortableDataProvider(collectionModel);
        CausewayAjaxDataTable dataTable = new CausewayAjaxDataTable(ID_TABLE, columns, dataProvider, collectionModel.getPageSize());
        this.addOrReplace(new Component[]{dataTable});
        this.createToggleboxColumn(dataTable).ifPresent(toggleboxColumn -> columns.add(0, (GenericColumn)toggleboxColumn));
        this.addFilterToolbar(dataTable);
    }

    private Optional<ToggleboxColumn> createToggleboxColumn(DataTableWithPagesAndFilter<?, ?> dataTable) {
        CollectionModel collectionModel = this.collectionModel();
        if (collectionModel instanceof CollectionModelParented) {
            CollectionModelParented collModel = (CollectionModelParented)collectionModel;
            OneToManyAssociation collMetaModel = collModel.getMetaModel();
            return collMetaModel.hasAssociatedActionsWithChoicesFromThisCollection() ? Optional.of(new ToggleboxColumn(collModel.getElementType(), dataTable)) : Optional.empty();
        }
        return Optional.empty();
    }

    private void addFilterToolbar(CausewayAjaxDataTable dataTableComponent) {
        Wkt.addIfElseHide(this.dataTableInteractive().isSearchSupported(), (MarkupContainer)this, ID_TABLE_FILTER_BAR, id -> new FilterToolbar((String)id, dataTableComponent));
    }

    private void prependTitleColumn(ObjectSpecification elementType, CollectionModel.Variant variant, CausewayConfiguration.Viewer.Wicket wktConfig, List<GenericColumn> columns) {
        Bookmark contextBookmark = this.collectionModel().getParentObject().getBookmark().orElse(null);
        int maxColumnTitleLength = ((CollectionModel)this.getModel()).getVariant().isParented() ? wktConfig.getMaxTitleLengthInParentedTables() : wktConfig.getMaxTitleLengthInStandaloneTables();
        ColumnAbbreviationOptions opts = new ColumnAbbreviationOptions(columns.size() == 0 ? wktConfig.getMaxTitleLengthInTablesNotHavingAnyPropertyColumn() : -1);
        columns.add(0, new TitleColumn(elementType, variant, contextBookmark, maxColumnTitleLength, opts));
    }

    private void addPropertyColumnsIfRequired(List<GenericColumn> columns) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        ObjectSpecification elementType = collectionModel.getElementType();
        if (elementType == null) {
            return;
        }
        ManagedObject parentObject = collectionModel.getParentObject();
        Identifier memberIdentifier = collectionModel.getIdentifier();
        elementType.streamAssociationsForColumnRendering(memberIdentifier, parentObject).map(ObjectAssociation::getSpecialization).map(spez -> (AssociationColumnAbstract)spez.fold(this::createSingularColumn, this::createPluralColumn)).forEach(columns::add);
    }

    private SingularColumn createSingularColumn(OneToOneAssociation property) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        String parentTypeName = property.getDeclaringType().logicalTypeName();
        Optional<String> sortability = property.getElementType().isComparableOrOrdered() ? Optional.of(property.getId()) : Optional.empty();
        return new SingularColumn(collectionModel.getElementType(), collectionModel.getVariant(), (IModel<String>)Model.of((Serializable)((Object)property.getCanonicalFriendlyName())), sortability, property.getId(), parentTypeName, property.getCanonicalDescription());
    }

    private PluralColumn createPluralColumn(OneToManyAssociation collection) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        String parentTypeName = collection.getDeclaringType().logicalTypeName();
        return new PluralColumn(collectionModel.getElementType(), collectionModel.getVariant(), (IModel<String>)Model.of((Serializable)((Object)collection.getCanonicalFriendlyName())), collection.getId(), parentTypeName, collection.getCanonicalDescription(), new PluralColumn.RenderOptions(50, 5, true));
    }

    private void addActionsColumnIfRequired(ObjectSpecification elementType, List<GenericColumn> columns) {
        CollectionModel collectionModel = (CollectionModel)this.getModel();
        Identifier memberIdentifier = collectionModel.getIdentifier();
        ActionColumn.create(memberIdentifier, elementType, collectionModel.getVariant()).ifPresent(columns::add);
    }
}

