/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns;

import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.object.ManagedObjects;
import org.apache.causeway.core.metamodel.spec.ObjectSpecification;
import org.apache.causeway.core.metamodel.spec.feature.ObjectMember;
import org.apache.causeway.core.metamodel.tabular.DataRow;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.model.models.ValueModel;
import org.apache.causeway.viewer.wicket.model.models.coll.CollectionModel;
import org.apache.causeway.viewer.wicket.model.models.coll.DataRowWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.ColumnAbbreviationOptions;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.columns.GenericColumnAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.jspecify.annotations.Nullable;

public final class TitleColumn
extends GenericColumnAbstract {
    private static final long serialVersionUID = 1L;
    private final CollectionModel.Variant variant;
    private final ColumnAbbreviationOptions opts;
    private final Bookmark contextBookmark;

    public TitleColumn(ObjectSpecification elementType, CollectionModel.Variant variant, Bookmark contextBookmark, int maxColumnTitleLength, ColumnAbbreviationOptions opts) {
        super(elementType, TitleColumn.columnName(variant, maxColumnTitleLength));
        this.variant = variant;
        this.contextBookmark = contextBookmark;
        this.opts = opts;
    }

    @Override
    protected Component createCellComponent(String componentId, DataRowWkt dataRowWkt) {
        DataRow dataRow = dataRowWkt.getObject();
        ManagedObject rowElement = dataRow.rowElement();
        if (ManagedObjects.isValue((ManagedObject)rowElement)) {
            ObjectMember objectMember = dataRow.parentTable().getMetaModel();
            ValueModel valueModel = new ValueModel(objectMember, rowElement);
            ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.VALUE, (IModel<?>)valueModel);
            return componentFactory.createComponent(componentId, (IModel<?>)valueModel);
        }
        UiObjectWkt uiObject = UiObjectWkt.ofAdapterForCollection((ManagedObject)rowElement, (CollectionModel.Variant)this.variant);
        uiObject.setContextBookmarkIfAny(this.contextBookmark);
        ComponentFactory componentFactory = this.findComponentFactory(UiComponentType.OBJECT_LINK, (IModel<?>)uiObject);
        Component objectLink = this.opts.applyTo(componentFactory.createComponent(componentId, (IModel<?>)uiObject));
        return objectLink;
    }

    boolean isTitleSuppressed() {
        return this.opts.maxElementTitleLength() <= 3;
    }

    private static String columnName(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable CollectionModel.Variant variant, int maxTitleLength) {
        if (maxTitleLength == 0) {
            return "";
        }
        return (variant.isParented() ? "Related " : "") + "Object";
    }
}

