/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.collection.selector;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.CollectionContentsAsFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryKey;
import org.apache.wicket.model.IModel;

record CollectionPresentationChoice(ComponentFactoryKey factoryKey, String label, int orderOfAppearanceInUiDropdown, boolean isPageReloadRequiredOnTableViewActivation, String cssClass) implements Serializable
{
    static CollectionPresentationChoice of(ComponentFactory componentFactory) {
        CollectionPresentationChoice collectionPresentationChoice;
        if (componentFactory instanceof CollectionContentsAsFactory) {
            CollectionContentsAsFactory choice = (CollectionContentsAsFactory)((Object)componentFactory);
            collectionPresentationChoice = new CollectionPresentationChoice(new ComponentFactoryKey(componentFactory), Optional.ofNullable(choice.getTitleLabel()).map(IModel::getObject).orElseGet(() -> componentFactory.getName()), choice.orderOfAppearanceInUiDropdown(), choice.isPageReloadRequiredOnTableViewActivation(), Optional.ofNullable(choice.getCssClass()).map(IModel::getObject).orElseGet(() -> (String)_Strings.asLowerDashed.apply((Object)componentFactory.getName())));
        } else {
            collectionPresentationChoice = new CollectionPresentationChoice(new ComponentFactoryKey(componentFactory), componentFactory.getName(), Integer.MAX_VALUE, false, null);
        }
        return collectionPresentationChoice;
    }

    static Comparator<? super CollectionPresentationChoice> orderByOrderOfAppearanceInUiDropdown() {
        return (a, b) -> Integer.compare(a.orderOfAppearanceInUiDropdown(), b.orderOfAppearanceInUiDropdown());
    }

    boolean isPresenter() {
        return this.factoryKey().componentType() == UiComponentType.COLLECTION_CONTENTS;
    }

    boolean isExporter() {
        return this.factoryKey().componentType() == UiComponentType.COLLECTION_CONTENTS_EXPORT;
    }

    String id() {
        return this.factoryKey.id();
    }

    ComponentFactory componentFactory() {
        return this.factoryKey.componentFactory();
    }

    @Override
    public final boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof CollectionPresentationChoice) {
            CollectionPresentationChoice other = (CollectionPresentationChoice)obj;
            bl = Objects.equals(this.id(), other.id());
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final int hashCode() {
        return this.id().hashCode();
    }
}

