/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.object.header;

import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.spec.feature.ObjectAction;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.model.models.ActionModel;
import org.apache.causeway.viewer.wicket.model.models.UiObjectWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.entityactions.ActionLinksPanel;
import org.apache.causeway.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.causeway.viewer.wicket.ui.util.WktComponents;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

public class ObjectHeaderPanel
extends PanelAbstract<ManagedObject, UiObjectWkt> {
    private static final long serialVersionUID = 1L;
    private static final String ID_OBJECT_ACTIONS = "objectActions";

    public ObjectHeaderPanel(String id, UiObjectWkt objectModel) {
        super(id, objectModel);
    }

    public UiObjectWkt getEntityModel() {
        return (UiObjectWkt)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceIconAndTitle();
        this.buildEntityActionsGui();
    }

    private void addOrReplaceIconAndTitle() {
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(UiComponentType.OBJECT_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getEntityModel());
        Component component = componentFactory.createComponent((IModel<?>)this.getEntityModel());
        this.addOrReplace(new Component[]{component});
    }

    private void buildEntityActionsGui() {
        UiObjectWkt model = (UiObjectWkt)this.getModel();
        ManagedObject adapter = (ManagedObject)model.getObject();
        if (adapter != null) {
            Can topLevelActions = (Can)ObjectAction.Util.streamTopBarActions((ManagedObject)adapter).map(act -> ActionModel.forEntity((ObjectAction)act, (UiObjectWkt)model)).collect(Can.toCan());
            ActionLinksPanel.addActionLinks((MarkupContainer)this, ID_OBJECT_ACTIONS, (Can<ActionModel>)topLevelActions, ActionLinksPanel.Style.INLINE_LIST);
        } else {
            WktComponents.permanentlyHide((MarkupContainer)this, ID_OBJECT_ACTIONS);
        }
    }
}

