/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.ui.components.table.nonav;

import java.io.Serializable;
import org.apache.causeway.core.metamodel.context.HasMetaModelContext;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.timetaken.TimeTakenModel;
import org.apache.causeway.viewer.wicket.ui.components.table.DataTableWithPagesAndFilter;
import org.apache.causeway.viewer.wicket.ui.components.table.nav.pagesize.PagesizeChooser;
import org.apache.causeway.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LambdaModel;
import org.danekja.java.util.function.serializable.SerializableSupplier;

public class TotalRecordsToolbar
extends AbstractToolbar
implements HasMetaModelContext {
    private static final long serialVersionUID = 1L;
    private static final String ID_NAVIGATOR_CONTAINER = "navigatorContainer";
    private static final String ID_PAGESIZE_CHOOSER = "pagesizeChooser";

    public TotalRecordsToolbar(DataTableWithPagesAndFilter<?, ?> table) {
        this(table, (IModel<String>)LambdaModel.of((SerializableSupplier & Serializable)() -> String.format("Showing all of %d", table.getRowCount())));
    }

    protected TotalRecordsToolbar(DataTableWithPagesAndFilter<?, ?> table, IModel<String> messageModel) {
        super(table);
        WebMarkupContainer navigatorContainer = Wkt.add((MarkupContainer)this, new WebMarkupContainer(ID_NAVIGATOR_CONTAINER));
        Wkt.add((MarkupContainer)navigatorContainer, new PagesizeChooser(ID_PAGESIZE_CHOOSER, table));
        navigatorContainer.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (IModel)LambdaModel.of((SerializableSupplier & Serializable)() -> String.valueOf(table.getColumns().size()).intern()))});
        Wkt.labelAdd((MarkupContainer)navigatorContainer, "navigatorLabel", messageModel);
        Wkt.labelAdd((MarkupContainer)navigatorContainer, "prototypingLabel", (IModel<String>)TimeTakenModel.createForPrototypingElseBlank((MetaModelContext)this.getMetaModelContext()));
    }

    protected void onConfigure() {
        super.onConfigure();
        if (this.getTable().getRowCount() <= 5L) {
            this.setVisible(false);
            return;
        }
        this.setVisible(this.getTable().getPageCount() == 1L);
    }
}

