/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.components;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.commons.collections.ImmutableEnumSet;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.base._Refs;
import org.apache.causeway.commons.internal.base._Text;
import org.apache.causeway.commons.internal.collections._Multimaps;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.commons.model.components.UiComponentType;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.ComponentFactoryAbstract;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistrar;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.ComponentFactoryRegistryDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class ComponentFactoryRegistryDefault
implements ComponentFactoryRegistry {
    private static final Logger log = LogManager.getLogger(ComponentFactoryRegistryDefault.class);
    @Inject
    private ComponentFactoryRegistrar componentFactoryRegistrar;
    @Inject
    private MetaModelContext metaModelContext;
    private final _Multimaps.ListMultimap<UiComponentType, ComponentFactory> componentFactoriesByComponentType = _Multimaps.newListMultimap();
    private final Map<Class<? extends ComponentFactory>, ComponentFactory> componentFactoriesByType = new HashMap<Class<? extends ComponentFactory>, ComponentFactory>();

    @PostConstruct
    public void init() {
        this.registerComponentFactories(this.componentFactoryRegistrar);
    }

    protected void registerComponentFactories(ComponentFactoryRegistrar componentFactoryRegistrar) {
        ComponentFactoryRegistrar.ComponentFactoryList componentFactories = new ComponentFactoryRegistrar.ComponentFactoryList();
        componentFactoryRegistrar.addComponentFactories(componentFactories);
        MetaModelContext commonContext = this.metaModelContext;
        for (ComponentFactory componentFactory : componentFactories) {
            this.registerComponentFactory(commonContext, componentFactory);
            this.componentFactoriesByType.put(componentFactory.getClass(), componentFactory);
        }
        this.ensureAllComponentTypesRegistered();
    }

    private void registerComponentFactory(MetaModelContext commonContext, ComponentFactory componentFactory) {
        commonContext.getServiceInjector().injectServicesInto((Object)componentFactory);
        if (componentFactory instanceof ComponentFactoryAbstract) {
            ((ComponentFactoryAbstract)componentFactory).setMetaModelContext(commonContext);
        }
        this.componentFactoriesByComponentType.putElement((Object)componentFactory.getComponentType(), (Object)componentFactory);
    }

    private void ensureAllComponentTypesRegistered() {
        for (UiComponentType componentType : UiComponentType.values()) {
            if (componentType.getOptionality().isOptional() || !this.componentFactoriesByComponentType.getOrElseEmpty((Object)componentType).isEmpty()) continue;
            throw new IllegalStateException("No component factories registered for " + componentType);
        }
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, UiComponentType uiComponentType, IModel<?> model) {
        Component component = this.createComponent(uiComponentType, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component addOrReplaceComponent(MarkupContainer markupContainer, String id, UiComponentType uiComponentType, IModel<?> model) {
        Component component = this.createComponent(id, uiComponentType, model);
        markupContainer.addOrReplace(new Component[]{component});
        return component;
    }

    public Component createComponent(UiComponentType uiComponentType, IModel<?> model) {
        return this.findComponentFactoryElseFail(uiComponentType, model).createComponent(model);
    }

    public Component createComponent(String id, UiComponentType uiComponentType, IModel<?> model) {
        return this.findComponentFactoryElseFail(uiComponentType, model).createComponent(id, model);
    }

    public Stream<ComponentFactory> streamComponentFactories(UiComponentType uiComponentType, @Nullable IModel<?> model) {
        _Refs.ObjectReference exclusiveIfAny = _Refs.objectRef(null);
        List allThatApply = this.componentFactoriesByComponentType.streamElements((Object)uiComponentType).filter(componentFactory -> {
            ComponentFactory.ApplicationAdvice advice = componentFactory.appliesTo(uiComponentType, model);
            if (advice.appliesExclusively()) {
                exclusiveIfAny.set(componentFactory);
            }
            return advice.applies();
        }).takeWhile(__ -> exclusiveIfAny.isNull()).collect(Collectors.toList());
        return (exclusiveIfAny.isNotNull() ? Stream.of((ComponentFactory)exclusiveIfAny.getValueElseFail()) : allThatApply.stream()).peek(componentFactory -> ComponentFactoryRegistryDefault.logComponentResolving(model, uiComponentType, componentFactory));
    }

    public Stream<ComponentFactory> streamComponentFactories(ImmutableEnumSet<UiComponentType> uiComponentTypes, @Nullable IModel<?> model) {
        return uiComponentTypes.stream().flatMap(componentType -> this.streamComponentFactories((UiComponentType)componentType, model));
    }

    public <T extends ComponentFactory> Optional<T> lookupFactory(Class<T> factoryClass) {
        return Optional.ofNullable(this.componentFactoriesByType.get(factoryClass));
    }

    private static void logComponentResolving(IModel<?> model, UiComponentType uiComponentType, ComponentFactory componentFactory) {
        if (!log.isDebugEnabled()) {
            return;
        }
        log.debug("component type for model {} -> {} provided by {}", (Object)_Text.abbreviateClassOf(model), (Object)uiComponentType.name(), (Object)_Text.abbreviateClassOf((Object)componentFactory));
    }

    static ComponentFactoryRegistryDefault forTesting(List<ComponentFactory> componentFactories) {
        ComponentFactoryRegistryDefault factory = new ComponentFactoryRegistryDefault();
        _NullSafe.stream(componentFactories).forEach(componentFactory -> factory.componentFactoriesByComponentType.putElement((Object)componentFactory.getComponentType(), componentFactory));
        return factory;
    }
}

