/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.pages;

import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassList;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistrySpi;
import org.apache.wicket.Page;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.PageClassRegistryDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class PageClassRegistryDefault
implements PageClassRegistry,
PageClassRegistrySpi {
    private static final long serialVersionUID = 1L;
    private final PageClassList pageClassList;
    private final Map<PageType, Class<? extends Page>> pageClassByType = _Maps.newHashMap();
    private final Map<Class<? extends Page>, PageType> typeByPageClass = _Maps.newHashMap();

    @Inject
    public PageClassRegistryDefault(PageClassList pageClassList) {
        this.pageClassList = pageClassList;
    }

    @PostConstruct
    public void init() {
        this.pageClassList.registerPages((PageClassRegistrySpi)this);
        this.ensureAllPageTypesRegistered();
    }

    private void ensureAllPageTypesRegistered() {
        for (PageType pageType : PageType.values()) {
            if (this.getPageClass(pageType) != null) continue;
            throw new IllegalStateException("No page registered for " + pageType);
        }
    }

    public final Class<? extends Page> getPageClass(PageType pageType) {
        return this.pageClassByType.get(pageType);
    }

    public PageType getPageType(Class<? extends Page> pageClass) {
        return this.typeByPageClass.get(pageClass);
    }

    public PageType getPageType(PageAbstract page) {
        return this.getPageType(page.getClass());
    }

    public final void registerPage(PageType pageType, Class<? extends Page> pageClass) {
        this.pageClassByType.put(pageType, pageClass);
        this.typeByPageClass.put(pageClass, pageType);
    }
}

