/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.services;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.causeway.applib.services.bookmark.Bookmark;
import org.apache.causeway.applib.services.homepage.HomePageResolverService;
import org.apache.causeway.applib.services.linking.DeepLinkService;
import org.apache.causeway.core.metamodel.object.ManagedObject;
import org.apache.causeway.core.metamodel.specloader.SpecificationLoader;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.model.util.PageParameterUtils;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.DeepLinkServiceWicket")
@Priority(value=0x1FFFFFFF)
@Qualifier(value="Wicket")
public class DeepLinkServiceWicket
implements DeepLinkService {
    private final PageClassRegistry pageClassRegistry;
    private final SpecificationLoader specificationLoader;
    private final HomePageResolverService homePageResolverService;

    public URI deepLinkFor(@Nullable Object domainObject) {
        RequestCycle requestCycle = RequestCycle.get();
        PageParameters pageParameters = this.pageParametersFor(domainObject).or(() -> this.pageParametersFor(this.homePageResolverService.getHomePage())).orElseThrow(() -> new RuntimeException("Cannot create a deep link to domain object: " + domainObject));
        Class pageClass = this.pageClassRegistry.getPageClass(PageType.ENTITY);
        CharSequence urlForPojo = requestCycle.urlFor(pageClass, pageParameters);
        String fullUrl = requestCycle.getUrlRenderer().renderFullUrl(Url.parse((CharSequence)urlForPojo));
        try {
            return new URI(fullUrl);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException("Cannot create a deep link to domain object: " + domainObject, ex);
        }
    }

    private Optional<PageParameters> pageParametersFor(@Nullable Object anyObject) {
        if (anyObject == null) {
            return Optional.empty();
        }
        try {
            if (anyObject instanceof ManagedObject) {
                return Optional.ofNullable(PageParameterUtils.createPageParametersForObject((ManagedObject)((ManagedObject)anyObject)));
            }
            if (anyObject instanceof Bookmark) {
                return Optional.ofNullable(PageParameterUtils.createPageParametersForBookmark((Bookmark)((Bookmark)anyObject)));
            }
            ManagedObject objectAdapter = ManagedObject.adaptSingular((SpecificationLoader)this.specificationLoader, (Object)anyObject);
            return Optional.ofNullable(PageParameterUtils.createPageParametersForObject((ManagedObject)objectAdapter));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Inject
    public DeepLinkServiceWicket(PageClassRegistry pageClassRegistry, SpecificationLoader specificationLoader, HomePageResolverService homePageResolverService) {
        this.pageClassRegistry = pageClassRegistry;
        this.specificationLoader = specificationLoader;
        this.homePageResolverService = homePageResolverService;
    }
}

