/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.integration;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.causeway.applib.services.i18n.TranslationContext;
import org.apache.causeway.applib.services.i18n.TranslationService;
import org.apache.causeway.applib.services.iactnlayer.InteractionLayerTracker;
import org.apache.causeway.applib.services.iactnlayer.InteractionService;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._Strings;
import org.apache.causeway.viewer.wicket.viewer.wicketapp.CausewayWicketApplication;
import org.apache.wicket.Component;
import org.apache.wicket.Localizer;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.wicketstuff.select2.Select2Choice;
import org.wicketstuff.select2.Select2MultiChoice;

public class LocalizerForCauseway
extends Localizer {
    @Inject
    private InteractionLayerTracker interactionLayerTracker;
    @Inject
    private InteractionService interactionService;
    @Inject
    private TranslationService translationService;

    public String getString(String key, Component component, IModel<?> model, Locale locale, String style, IModel<String> defaultValue) throws MissingResourceException {
        String translated = this.translate(key, component);
        if (!_Strings.isNullOrEmpty((CharSequence)translated) && !translated.equals(key)) {
            return translated;
        }
        return super.getString(key, component, model, locale, style, defaultValue);
    }

    protected String translate(String key, Component component) {
        Class<?> contextClass = this.determineContextClassElse(component, CausewayWicketApplication.class);
        TranslationContext context = TranslationContext.forClassName(contextClass);
        if (this.interactionLayerTracker.isInInteraction()) {
            return this.translate(key, context);
        }
        return (String)this.interactionService.callAnonymous(() -> this.translate(key, context));
    }

    private Class<?> determineContextClassElse(Component component, Class<?> fallback) {
        if (component == null) {
            return fallback;
        }
        if (component instanceof Select2Choice || component instanceof Select2MultiChoice) {
            return component.getClass();
        }
        return this.pageElseSignificantParentOf(component).map(parentComponent -> this.enclosing(parentComponent.getClass())).orElse((Class)_Casts.uncheckedCast(fallback));
    }

    private Optional<Component> pageElseSignificantParentOf(Component component) {
        Component page = this.pageOf(component);
        if (page != null) {
            return Optional.of(page);
        }
        return this.parentFormOrPanelOf(component);
    }

    private Component pageOf(Component component) {
        if (component instanceof Page) {
            return component;
        }
        MarkupContainer parent = component.getParent();
        if (parent != null) {
            return this.pageOf((Component)parent);
        }
        return component;
    }

    private Optional<Component> parentFormOrPanelOf(Component component) {
        if (component instanceof Form || component instanceof Panel) {
            return Optional.of(component);
        }
        MarkupContainer parent = component.getParent();
        if (parent != null) {
            return this.parentFormOrPanelOf((Component)parent);
        }
        return Optional.empty();
    }

    private Class<?> enclosing(Class<?> cls) {
        Class<?> enclosingClass = cls.getEnclosingClass();
        return enclosingClass != null ? this.enclosing(enclosingClass) : cls;
    }

    private String translate(String key, TranslationContext context) {
        return this.translationService.translate(context, key);
    }
}

