/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.pages;

import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.PageNavigationService;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="causeway.viewer.wicket.PageNavigationServiceDefault")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class PageNavigationServiceDefault
implements PageNavigationService {
    private static final long serialVersionUID = 1L;
    @Inject
    private PageClassRegistry pageClassRegistry;

    public void navigateTo(PageType pageType) {
        this.navigateTo(pageType, new PageParameters());
    }

    public void navigateTo(PageType pageType, PageParameters parameters) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        RequestCycle.get().setResponsePage(pageClass, parameters);
    }

    public void restartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseException(pageClass);
    }

    public void interceptAndRestartAt(PageType pageType) {
        Class pageClass = this.pageClassRegistry.getPageClass(pageType);
        throw new RestartResponseAtInterceptPageException(pageClass);
    }
}

