/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.components;

import java.io.Serializable;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.causeway.applib.tabular.TabularExporter;
import org.apache.causeway.applib.value.semantics.ValueSemanticsProvider;
import org.apache.causeway.applib.value.semantics.ValueSemanticsResolver;
import org.apache.causeway.commons.collections.Can;
import org.apache.causeway.commons.internal.base._Casts;
import org.apache.causeway.commons.internal.base._NullSafe;
import org.apache.causeway.commons.internal.functions._Predicates;
import org.apache.causeway.core.metamodel.commons.ClassUtil;
import org.apache.causeway.core.metamodel.context.MetaModelContext;
import org.apache.causeway.viewer.wicket.model.models.UiAttributeWkt;
import org.apache.causeway.viewer.wicket.ui.ComponentFactory;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryList;
import org.apache.causeway.viewer.wicket.ui.app.registry.ComponentFactoryRegistry;
import org.apache.causeway.viewer.wicket.ui.components.about.AboutPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actioninfo.ActionInfoPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.ServiceActionsPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actionlinks.serviceactions.TertiaryMenuPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actions.ActionParametersFormPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.actions.ActionParametersPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.AttributeComponentFactoryWithTypeConstraint;
import org.apache.causeway.viewer.wicket.ui.components.attributes.NumericAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.blobclob.BlobAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.blobclob.ClobAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.bool.BooleanAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.choices.ChoicesSelect2PanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.image.JavaAwtImagePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.markup.MarkupAttributePanelFactories;
import org.apache.causeway.viewer.wicket.ui.components.attributes.passwd.PasswordAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.string.StringAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.attributes.temporal.TemporalAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.value.CompositeValueAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.value.ValueAttributePanel;
import org.apache.causeway.viewer.wicket.ui.components.attributes.value.ValueFallbackAttributePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.bookmarkedpages.BookmarkedPagesPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.export.CollectionContentsAsExportFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.parented.ParentedCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.ajaxtable.CollectionContentsAsAjaxTablePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.multiple.CollectionContentsMultipleViewsPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.summary.CollectionContentsAsSummaryFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.present.unresolved.CollectionContentsHiddenPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.collection.standalone.StandaloneCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.empty.EmptyCollectionPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.footer.FooterPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.header.HeaderPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.layout.bs.BSGridPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.object.header.ObjectHeaderPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.object.icontitle.ObjectIconAndTitlePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.object.icontitle.ObjectIconTitleAndCopyLinkPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.property.PropertyEditFormPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.property.PropertyEditPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.tree.TreePanelFactories;
import org.apache.causeway.viewer.wicket.ui.components.unknown.UnknownModelPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.value.StandaloneValuePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.voidreturn.VoidReturnPanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.welcome.WelcomePanelFactory;
import org.apache.causeway.viewer.wicket.ui.components.widgets.objectsimplelink.ObjectLinkSimplePanelFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wicket.Component;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
public class ComponentFactoryConfigWkt {
    @Generated
    private static final Logger log = LogManager.getLogger(ComponentFactoryConfigWkt.class);

    @Bean
    public ComponentFactoryList componentFactoryList(@Autowired(required=true) ValueSemanticsResolver valueSemanticsResolver, @Autowired(required=false) List<TabularExporter> tabularExporters, List<ComponentFactory> componentFactoriesPluggedIn) {
        ComponentFactoryList factoryList = new ComponentFactoryList();
        this.addComponentFactoriesActingAsSelectors(factoryList);
        log.info("adding {} ComponentFactories from plugins: {}", (Object)_NullSafe.size(componentFactoriesPluggedIn), componentFactoriesPluggedIn);
        _NullSafe.stream(componentFactoriesPluggedIn).forEach(arg_0 -> ((ComponentFactoryList)factoryList).add(arg_0));
        this.addComponentFactoriesForWelcomeAndAbout(factoryList);
        this.addComponentFactoriesForApplicationActions(factoryList);
        this.addComponentFactoriesForEntity(factoryList);
        this.addComponentFactoriesForActionInfo(factoryList);
        this.addComponentFactoriesForAction(factoryList);
        this.addComponentFactoriesForPropertyEdit(factoryList);
        this.addComponentFactoriesForEntityCollectionContents(factoryList, tabularExporters);
        this.addComponentFactoriesForEmptyCollection(factoryList);
        this.addComponentFactoriesForScalar(factoryList, valueSemanticsResolver);
        this.addComponentFactoriesForEntityLink(factoryList);
        this.addComponentFactoriesForVoidReturn(factoryList);
        this.addComponentFactoriesForValue(factoryList);
        this.addComponentFactoriesForParameters(factoryList);
        this.addComponentFactoriesForBreadcrumbs(factoryList);
        this.addComponentFactoriesForPageHeader(factoryList);
        this.addComponentFactoriesForPageFooter(factoryList);
        this.addComponentFactoriesForUnknown(factoryList);
        return factoryList;
    }

    @Bean
    public ComponentFactoryRegistry componentFactoryRegistry(@Autowired(required=true) ComponentFactoryList factoryList, @Autowired(required=true) MetaModelContext metaModelContext) {
        return new ComponentFactoryRegistry(factoryList, metaModelContext);
    }

    protected void addComponentFactoriesActingAsSelectors(ComponentFactoryList componentFactories) {
        this.addLinksSelectorFactories(componentFactories);
        componentFactories.add((ComponentFactory)new CollectionContentsHiddenPanelFactory());
    }

    protected void addLinksSelectorFactories(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new CollectionContentsMultipleViewsPanelFactory());
    }

    protected void addComponentFactoriesForPageHeader(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new HeaderPanelFactory());
    }

    protected void addComponentFactoriesForPageFooter(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new FooterPanelFactory());
    }

    protected void addComponentFactoriesForWelcomeAndAbout(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new WelcomePanelFactory());
        componentFactories.add((ComponentFactory)new AboutPanelFactory());
    }

    protected void addComponentFactoriesForEntity(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new BSGridPanelFactory());
        componentFactories.add((ComponentFactory)new ObjectIconAndTitlePanelFactory());
        componentFactories.add((ComponentFactory)new ObjectIconTitleAndCopyLinkPanelFactory());
        componentFactories.add((ComponentFactory)new ObjectHeaderPanelFactory());
        componentFactories.add((ComponentFactory)new ParentedCollectionPanelFactory());
    }

    protected void addComponentFactoriesForEntityCollectionContents(ComponentFactoryList componentFactories, List<TabularExporter> tabularExporters) {
        componentFactories.add((ComponentFactory)new CollectionContentsAsAjaxTablePanelFactory());
        _NullSafe.stream(tabularExporters).map(CollectionContentsAsExportFactory::new).forEach(arg_0 -> ((ComponentFactoryList)componentFactories).add(arg_0));
        componentFactories.add((ComponentFactory)new CollectionContentsAsSummaryFactory());
    }

    protected void addComponentFactoriesForEmptyCollection(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new EmptyCollectionPanelFactory());
    }

    protected void addComponentFactoriesForValue(ComponentFactoryList componentFactories) {
        componentFactories.add(MarkupAttributePanelFactories.standalone());
        componentFactories.add(TreePanelFactories.standalone());
        componentFactories.add((ComponentFactory)new StandaloneValuePanelFactory());
    }

    protected void addComponentFactoriesForScalar(ComponentFactoryList componentFactories, ValueSemanticsResolver valueSemanticsResolver) {
        componentFactories.add(TreePanelFactories.parented());
        componentFactories.add(MarkupAttributePanelFactories.parented());
        componentFactories.add((ComponentFactory)new BooleanAttributePanelFactory());
        componentFactories.add((ComponentFactory)new StringAttributePanelFactory());
        componentFactories.add((ComponentFactory)new JavaAwtImagePanelFactory());
        componentFactories.add((ComponentFactory)new PasswordAttributePanelFactory());
        componentFactories.add((ComponentFactory)new BlobAttributePanelFactory());
        componentFactories.add((ComponentFactory)new ClobAttributePanelFactory());
        this.addGenericComponentFactoriesForScalar(componentFactories, valueSemanticsResolver);
        componentFactories.add((ComponentFactory)new ValueFallbackAttributePanelFactory());
        componentFactories.add((ComponentFactory)new ChoicesSelect2PanelFactory());
    }

    protected void addComponentFactoriesForEntityLink(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ObjectLinkSimplePanelFactory());
    }

    protected void addComponentFactoriesForVoidReturn(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new VoidReturnPanelFactory());
    }

    protected void addComponentFactoriesForActionInfo(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionInfoPanelFactory());
    }

    protected void addComponentFactoriesForParameters(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionParametersFormPanelFactory());
    }

    protected void addComponentFactoriesForAction(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ActionParametersPanelFactory());
        componentFactories.add((ComponentFactory)new StandaloneCollectionPanelFactory());
    }

    protected void addComponentFactoriesForPropertyEdit(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new PropertyEditPanelFactory());
        componentFactories.add((ComponentFactory)new PropertyEditFormPanelFactory());
    }

    protected void addComponentFactoriesForApplicationActions(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new ServiceActionsPanelFactory());
        componentFactories.add((ComponentFactory)new TertiaryMenuPanelFactory());
    }

    protected void addComponentFactoriesForBreadcrumbs(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new BookmarkedPagesPanelFactory());
    }

    protected void addComponentFactoriesForUnknown(ComponentFactoryList componentFactories) {
        componentFactories.add((ComponentFactory)new UnknownModelPanelFactory());
    }

    public static <T extends Serializable> AttributeComponentFactoryWithTypeConstraint createForValueSemantics(ValueSemanticsProvider<T> valueSemantics) {
        if (valueSemantics.isNumberType()) {
            return new ScalarPanelFactoryForNumberField(valueSemantics.getCorrespondingClass());
        }
        if (valueSemantics.isTemporalType()) {
            return (AttributeComponentFactoryWithTypeConstraint)_Casts.uncheckedCast(new ScalarPanelFactoryForTemporalPicker(valueSemantics.getCorrespondingClass()));
        }
        if (valueSemantics.isCompositeType()) {
            return new ScalarPanelFactoryForCompositeValue(valueSemantics.getCorrespondingClass());
        }
        return new ScalarPanelFactoryForTextField(valueSemantics.getCorrespondingClass());
    }

    private void addGenericComponentFactoriesForScalar(ComponentFactoryList componentFactories, ValueSemanticsResolver valueSemanticsResolver) {
        Set registeredElementTypes = componentFactories.stream(AttributeComponentFactoryWithTypeConstraint.class).flatMap(f -> f.elementTypes().stream()).collect(Collectors.toSet());
        valueSemanticsResolver.streamClassesWithValueSemantics().filter(_Predicates.not(registeredElementTypes::contains)).flatMap(arg_0 -> ((ValueSemanticsResolver)valueSemanticsResolver).streamValueSemantics(arg_0)).map(valueSemantics -> ComponentFactoryConfigWkt.createForValueSemantics(valueSemantics)).forEach(arg_0 -> ((ComponentFactoryList)componentFactories).add(arg_0));
    }

    private static Can<Class<?>> withPrimitiveVariant(@NonNull Class<?> valueTypeClass) {
        if (valueTypeClass == null) {
            throw new NullPointerException("valueTypeClass is marked non-null but is null");
        }
        Can valueTypeClasses = Can.ofSingleton(valueTypeClass);
        if (ClassUtils.isPrimitiveWrapper(valueTypeClass)) {
            Class unboxed = ClassUtil.unboxPrimitiveIfNecessary(valueTypeClass);
            valueTypeClasses = valueTypeClasses.add((Object)unboxed);
        }
        return valueTypeClasses;
    }

    public static class ScalarPanelFactoryForNumberField<T extends Serializable>
    extends AttributeComponentFactoryWithTypeConstraint {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForNumberField(Class<T> valueTypeClass) {
            super(NumericAttributePanel.class, ComponentFactoryConfigWkt.withPrimitiveVariant(valueTypeClass));
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new NumericAttributePanel(id, attributeModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForTemporalPicker<T extends Serializable & Temporal>
    extends AttributeComponentFactoryWithTypeConstraint {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForTemporalPicker(Class<T> valueTypeClass) {
            super(TemporalAttributePanel.class, valueTypeClass);
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new TemporalAttributePanel(id, attributeModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForCompositeValue<T extends Serializable>
    extends AttributeComponentFactoryWithTypeConstraint {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForCompositeValue(Class<T> valueTypeClass) {
            super(CompositeValueAttributePanel.class, valueTypeClass);
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new CompositeValueAttributePanel(id, attributeModel, this.valueTypeClass);
        }
    }

    public static class ScalarPanelFactoryForTextField<T extends Serializable>
    extends AttributeComponentFactoryWithTypeConstraint {
        private final Class<T> valueTypeClass;

        protected ScalarPanelFactoryForTextField(Class<T> valueTypeClass) {
            super(ValueAttributePanel.class, ComponentFactoryConfigWkt.withPrimitiveVariant(valueTypeClass));
            this.valueTypeClass = valueTypeClass;
        }

        public Component createComponent(String id, UiAttributeWkt attributeModel) {
            return new ValueAttributePanel(id, attributeModel, this.valueTypeClass);
        }
    }
}

