/*
 * Decompiled with CFR 0.152.
 */
package org.apache.causeway.viewer.wicket.viewer.registries.pages;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import org.apache.causeway.commons.internal.collections._Maps;
import org.apache.causeway.viewer.wicket.model.models.PageType;
import org.apache.causeway.viewer.wicket.ui.pages.PageAbstract;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassList;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.causeway.viewer.wicket.ui.pages.PageClassRegistrySpi;
import org.apache.wicket.Page;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

public class PageClassRegistryDefault
implements PageClassRegistry,
PageClassRegistrySpi {
    public static final String LOGICAL_TYPE_NAME = "causeway.viewer.wicket.PageClassRegistryDefault";
    private static final long serialVersionUID = 1L;
    private final PageClassList pageClassList;
    private final Map<PageType, Class<? extends Page>> pageClassByType = _Maps.newHashMap();
    private final Map<Class<? extends Page>, PageType> typeByPageClass = _Maps.newHashMap();

    @Inject
    public PageClassRegistryDefault(PageClassList pageClassList) {
        this.pageClassList = pageClassList;
    }

    @PostConstruct
    public void init() {
        this.pageClassList.registerPages((PageClassRegistrySpi)this);
        this.ensureAllPageTypesRegistered();
    }

    private void ensureAllPageTypesRegistered() {
        for (PageType pageType : PageType.values()) {
            if (this.getPageClass(pageType) != null) continue;
            throw new IllegalStateException("No page registered for " + String.valueOf(pageType));
        }
    }

    public final Class<? extends Page> getPageClass(PageType pageType) {
        return this.pageClassByType.get(pageType);
    }

    public PageType getPageType(Class<? extends Page> pageClass) {
        return this.typeByPageClass.get(pageClass);
    }

    public PageType getPageType(PageAbstract page) {
        return this.getPageType(page.getClass());
    }

    public final void registerPage(PageType pageType, Class<? extends Page> pageClass) {
        this.pageClassByType.put(pageType, pageClass);
        this.typeByPageClass.put(pageClass, pageType);
    }

    @Configuration
    public static class AutoConfiguration {
        @Bean
        @Named(value="causeway.viewer.wicket.PageClassRegistryDefault")
        @Order(value=0x3FFFFFFF)
        @Qualifier(value="Default")
        public PageClassRegistryDefault pageClassRegistryDefault(PageClassList pageClassList) {
            return new PageClassRegistryDefault(pageClassList);
        }
    }
}

