/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.report;

import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.report.AbstractCmisTestReport;

public class XmlReport
extends AbstractCmisTestReport {
    private static final String TAG_REPORT = "report";
    private static final String TAG_PARAMETERS = "parameters";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_GROUP = "group";
    private static final String TAG_TEST = "test";
    private static final String TAG_RESULT = "result";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TIME = "time";
    private static final String ATTR_STATUS = "status";
    private static final String ATTR_MESSAGE = "message";

    @Override
    public void createReport(Map<String, String> parameters, List<CmisTestGroup> groups, Writer writer) throws Exception {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        XMLStreamWriter xml = factory.createXMLStreamWriter(writer);
        xml.writeStartDocument();
        xml.writeStartElement(TAG_REPORT);
        if (parameters != null) {
            xml.writeStartElement(TAG_PARAMETERS);
            for (Map.Entry entry : new TreeMap<String, String>(parameters).entrySet()) {
                xml.writeStartElement(TAG_PARAMETER);
                xml.writeAttribute(ATTR_KEY, (String)entry.getKey());
                if (entry.getValue() != null) {
                    xml.writeAttribute(ATTR_VALUE, (String)entry.getValue());
                }
                xml.writeEndElement();
            }
            xml.writeEndElement();
        }
        if (groups != null) {
            for (CmisTestGroup cmisTestGroup : groups) {
                this.printGroupResults(cmisTestGroup, xml);
            }
        }
        xml.writeEndElement();
        xml.writeEndDocument();
        xml.flush();
    }

    private void printGroupResults(CmisTestGroup group, XMLStreamWriter xml) throws Exception {
        if (!group.isEnabled()) {
            return;
        }
        xml.writeStartElement(TAG_GROUP);
        xml.writeAttribute(ATTR_NAME, group.getName());
        if (group.getTests() != null) {
            for (CmisTest test : group.getTests()) {
                this.printTestResults(test, xml);
            }
        }
        xml.writeEndElement();
    }

    private void printTestResults(CmisTest test, XMLStreamWriter xml) throws Exception {
        if (!test.isEnabled()) {
            return;
        }
        xml.writeStartElement(TAG_TEST);
        xml.writeAttribute(ATTR_NAME, test.getName());
        xml.writeAttribute(ATTR_TIME, String.valueOf(test.getTime()));
        if (test.getResults() != null) {
            for (CmisTestResult result : test.getResults()) {
                this.printResult(result, xml);
            }
        }
        xml.writeEndElement();
    }

    private void printResult(CmisTestResult result, XMLStreamWriter xml) throws Exception {
        xml.writeStartElement(TAG_RESULT);
        xml.writeAttribute(ATTR_STATUS, result.getStatus().toString());
        xml.writeAttribute(ATTR_MESSAGE, result.getMessage());
        for (CmisTestResult child : result.getChildren()) {
            this.printResult(child, xml);
        }
        xml.writeEndElement();
    }
}

