/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.chemistry.opencmis.client.api.AsyncSession;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.async.AbstractExecutorServiceAsyncSession;
import org.apache.chemistry.opencmis.client.runtime.async.AsyncSessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

public class AsyncCreateAndDeleteFolderTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Asynchronous Create and Delete Folder Test");
        this.setDescription("Creates folders in parallel and deletes the created folders in parallel.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        int numOfFolders = 100;
        AsyncSession asyncSession = AsyncSessionFactoryImpl.newInstance().createAsyncSession(session, 10);
        Folder testFolder = this.createTestFolder(session);
        try {
            ArrayList<Future> folderFutures = new ArrayList<Future>();
            for (int i = 0; i < numOfFolders; ++i) {
                String name = "asyncfolder" + i;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("cmis:name", name);
                properties.put("cmis:objectTypeId", this.getFolderTestTypeId());
                Future newFolder = asyncSession.createFolder(properties, (ObjectId)testFolder);
                folderFutures.add(newFolder);
            }
            ArrayList<ObjectId> folderIds = new ArrayList<ObjectId>();
            try {
                for (Future folderFuture : folderFutures) {
                    ObjectId id = (ObjectId)folderFuture.get();
                    folderIds.add(id);
                }
            }
            catch (Exception e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not been created! Exception: " + e.getMessage(), e, true));
            }
            int count = this.countChildren(testFolder);
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Test folder should have " + numOfFolders + " children but has " + count + "!");
            this.addResult(this.assertEquals(count, numOfFolders, null, (CmisTestResult)f));
            HashMap<String, Future> getObjectFutures = new HashMap<String, Future>();
            for (ObjectId objectId : folderIds) {
                Future future = asyncSession.getObject(objectId, SELECT_ALL_NO_CACHE_OC);
                getObjectFutures.put(objectId.getId(), future);
            }
            ArrayList<String> paths = new ArrayList<String>();
            try {
                for (Map.Entry entry : getObjectFutures.entrySet()) {
                    CmisObject cmisObject = (CmisObject)((Future)entry.getValue()).get();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetching folder failed!");
                    this.addResult(this.assertIsTrue(cmisObject instanceof Folder, null, f));
                    if (cmisObject == null) continue;
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetched wrong folder!");
                    this.addResult(this.assertEquals(entry.getKey(), cmisObject.getId(), null, (CmisTestResult)f));
                    paths.add(((Folder)cmisObject).getPath());
                }
            }
            catch (Exception exception) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folders could not been fetched! Exception: " + exception.getMessage(), exception, true));
            }
            HashMap<String, Future> hashMap = new HashMap<String, Future>();
            for (String string : paths) {
                Future getObjectByPathFuture = asyncSession.getObjectByPath(string, SELECT_ALL_NO_CACHE_OC);
                hashMap.put(string, getObjectByPathFuture);
            }
            try {
                for (Map.Entry entry : hashMap.entrySet()) {
                    CmisObject object = (CmisObject)((Future)entry.getValue()).get();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetching folder failed!");
                    this.addResult(this.assertIsTrue(object instanceof Folder, null, f));
                    if (object == null) continue;
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Fetched wrong folder!");
                    this.addResult(this.assertEquals(entry.getKey(), ((Folder)object).getPath(), null, (CmisTestResult)f));
                }
            }
            catch (Exception exception) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folders could not been fetched! Exception: " + exception.getMessage(), exception, true));
            }
            ArrayList<Future> arrayList = new ArrayList<Future>();
            for (ObjectId folderId : folderIds) {
                Future delFuture = asyncSession.deleteTree(folderId, true, UnfileObject.DELETE, true);
                arrayList.add(delFuture);
            }
            try {
                for (Future delFuture : arrayList) {
                    delFuture.get();
                }
            }
            catch (Exception exception) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not been deleted! Exception: " + exception.getMessage(), exception, true));
            }
            count = this.countChildren(testFolder);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Test folder should be empty but has " + count + " children!");
            this.addResult(this.assertEquals(count, 0, null, (CmisTestResult)f));
        }
        finally {
            this.deleteTestFolder();
            if (asyncSession instanceof AbstractExecutorServiceAsyncSession) {
                ((AbstractExecutorServiceAsyncSession)asyncSession).shutdown();
            }
        }
        this.addResult(this.createInfoResult("Tested the parallel creation and deletion of " + numOfFolders + " folders."));
    }

    private int countChildren(Folder folder) {
        int count = 0;
        ItemIterable children = folder.getChildren(SELECT_ALL_NO_CACHE_OC);
        for (CmisObject child : children) {
            if (!(child instanceof Folder)) continue;
            ++count;
        }
        return count;
    }
}

