/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commander;

import java.io.PrintWriter;
import org.apache.chemistry.opencmis.commander.Command;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.spi.CmisBinding;

public class ListCommand
implements Command {
    public String getCommandName() {
        return "list";
    }

    public String getUsage() {
        return "LIST <repository id> <folder id>";
    }

    public void execute(CmisBinding binding, String[] args, PrintWriter output) {
        if (args.length < 2) {
            output.println(this.getUsage());
            return;
        }
        String repositoryId = args[0];
        String folderId = args[1];
        ObjectInFolderList list = binding.getNavigationService().getChildren(repositoryId, folderId, null, null, null, null, null, null, null, null, null);
        for (ObjectInFolderData object : list.getObjects()) {
            output.println(ListCommand.getPropertyValue(object, "cmis:objectId") + "\t" + ListCommand.getPropertyValue(object, "cmis:name") + "\t" + ListCommand.getPropertyValue(object, "cmis:objectTypeId"));
        }
    }

    private static String getPropertyValue(ObjectInFolderData object, String name) {
        if (object == null || object.getObject() == null || object.getObject().getProperties() == null || object.getObject().getProperties().getProperties() == null) {
            return "?";
        }
        PropertyData property = (PropertyData)object.getObject().getProperties().getProperties().get(name);
        if (property == null || property.getFirstValue() == null) {
            return "<not set>";
        }
        return property.getFirstValue().toString();
    }
}

