/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import groovy.ui.Console;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import org.apache.chemistry.opencmis.workbench.ChangeLogFrame;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.CreateDocumentDialog;
import org.apache.chemistry.opencmis.workbench.CreateFolderDialog;
import org.apache.chemistry.opencmis.workbench.FolderPanel;
import org.apache.chemistry.opencmis.workbench.InfoDialog;
import org.apache.chemistry.opencmis.workbench.LogFrame;
import org.apache.chemistry.opencmis.workbench.LoginDialog;
import org.apache.chemistry.opencmis.workbench.QueryFrame;
import org.apache.chemistry.opencmis.workbench.RepositoryInfoFrame;
import org.apache.chemistry.opencmis.workbench.TckDialog;
import org.apache.chemistry.opencmis.workbench.TypesFrame;
import org.apache.chemistry.opencmis.workbench.details.DetailsTabs;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;

public class ClientFrame
extends JFrame
implements WindowListener {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Workbench";
    private static final int BUTTON_CONNECT = 0;
    private static final int BUTTON_REPOSITORY_INFO = 1;
    private static final int BUTTON_TYPES = 2;
    private static final int BUTTON_QUERY = 3;
    private static final int BUTTON_CHANGELOG = 4;
    private static final int BUTTON_CONSOLE = 5;
    private static final int BUTTON_TCK = 6;
    private static final int BUTTON_CREATE_DOCUMENT = 7;
    private static final int BUTTON_CREATE_FOLDER = 8;
    private static final int BUTTON_LOG = 9;
    private static final int BUTTON_INFO = 10;
    private static final String PREFS_X = "x";
    private static final String PREFS_Y = "y";
    private static final String PREFS_WIDTH = "width";
    private static final String PREFS_HEIGHT = "height";
    private static final String PREFS_DIV = "div";
    private static final String GROOVY_SCRIPT_FOLDER = "/scripts/";
    private static final String GROOVY_SCRIPT_LIBRARY = "script-library.properties";
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private LoginDialog loginDialog;
    private LogFrame logFrame;
    private InfoDialog infoDialog;
    private JToolBar toolBar;
    private JButton[] toolbarButton;
    private JPopupMenu toolbarConsolePopup;
    private JSplitPane split;
    private FolderPanel folderPanel;
    private DetailsTabs detailsTabs;
    private final ClientModel model;

    public ClientFrame() {
        ClientHelper.installKeyBindings();
        this.model = new ClientModel();
        this.createGUI();
        this.showLoginForm();
    }

    private void createGUI() {
        this.setTitle(WINDOW_TITLE);
        ImageIcon icon = ClientHelper.getIcon("icon.png");
        if (icon != null) {
            this.setIconImage(icon.getImage());
        }
        this.setLayout(new BorderLayout());
        final ClientFrame thisFrame = this;
        this.loginDialog = new LoginDialog(this);
        this.logFrame = new LogFrame();
        this.infoDialog = new InfoDialog(this);
        Container pane = this.getContentPane();
        this.toolBar = new JToolBar("CMIS Toolbar", 0);
        this.toolbarButton = new JButton[11];
        this.toolbarButton[0] = new JButton("Connection", ClientHelper.getIcon("connect.png"));
        this.toolbarButton[0].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.showLoginForm();
            }
        });
        this.toolBar.add(this.toolbarButton[0]);
        this.toolBar.addSeparator();
        this.toolbarButton[1] = new JButton("Repository Info", ClientHelper.getIcon("repository-info.png"));
        this.toolbarButton[1].setEnabled(false);
        this.toolbarButton[1].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new RepositoryInfoFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[1]);
        this.toolbarButton[2] = new JButton("Types", ClientHelper.getIcon("types.png"));
        this.toolbarButton[2].setEnabled(false);
        this.toolbarButton[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TypesFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[2]);
        this.toolbarButton[3] = new JButton("Query", ClientHelper.getIcon("query.png"));
        this.toolbarButton[3].setEnabled(false);
        this.toolbarButton[3].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new QueryFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[3]);
        this.toolbarButton[4] = new JButton("Change Log", ClientHelper.getIcon("changelog.png"));
        this.toolbarButton[4].setEnabled(false);
        this.toolbarButton[4].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new ChangeLogFrame(ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[4]);
        this.toolbarButton[5] = new JButton("Console", ClientHelper.getIcon("console.png"));
        this.toolbarButton[5].setEnabled(false);
        this.toolbarButton[5].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.toolbarConsolePopup.show(ClientFrame.this.toolbarButton[5], 0, ClientFrame.this.toolbarButton[5].getHeight());
            }
        });
        this.toolBar.add(this.toolbarButton[5]);
        this.toolbarConsolePopup = new JPopupMenu();
        for (ClientHelper.FileEntry fe : this.readScriptLibrary()) {
            JMenuItem menuItem = new JMenuItem(fe.getName());
            final String file = fe.getFile();
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClientFrame.this.openConsole(file);
                }
            });
            this.toolbarConsolePopup.add(menuItem);
        }
        this.toolbarButton[6] = new JButton("TCK", ClientHelper.getIcon("tck.png"));
        this.toolbarButton[6].setEnabled(false);
        this.toolbarButton[6].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new TckDialog(thisFrame, ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[6]);
        this.toolBar.addSeparator();
        this.toolbarButton[7] = new JButton("Create Document", ClientHelper.getIcon("newdocument.png"));
        this.toolbarButton[7].setEnabled(false);
        this.toolbarButton[7].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CreateDocumentDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[7]);
        this.toolbarButton[8] = new JButton("Create Folder", ClientHelper.getIcon("newfolder.png"));
        this.toolbarButton[8].setEnabled(false);
        this.toolbarButton[8].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new CreateFolderDialog((Frame)thisFrame, ClientFrame.this.model);
            }
        });
        this.toolBar.add(this.toolbarButton[8]);
        this.toolBar.addSeparator();
        this.toolbarButton[9] = new JButton("Log", ClientHelper.getIcon("log.png"));
        this.toolbarButton[9].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.logFrame.showFrame();
            }
        });
        this.toolBar.add(this.toolbarButton[9]);
        this.toolbarButton[10] = new JButton("Info", ClientHelper.getIcon("info.png"));
        this.toolbarButton[10].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClientFrame.this.infoDialog.showDialog();
            }
        });
        this.toolBar.add(this.toolbarButton[10]);
        pane.add((Component)this.toolBar, "First");
        this.folderPanel = new FolderPanel(this.model);
        this.detailsTabs = new DetailsTabs(this.model);
        this.split = new JSplitPane(1, this.folderPanel, this.detailsTabs);
        pane.add((Component)this.split, "Center");
        this.addWindowListener(this);
        this.setPreferredSize(new Dimension(this.prefs.getInt(PREFS_WIDTH, 1000), this.prefs.getInt(PREFS_HEIGHT, 600)));
        this.setMinimumSize(new Dimension(200, 60));
        this.setDefaultCloseOperation(3);
        this.pack();
        this.split.setDividerLocation(this.prefs.getInt(PREFS_DIV, 500));
        if (this.prefs.getInt(PREFS_X, Integer.MAX_VALUE) == Integer.MAX_VALUE) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation(this.prefs.getInt(PREFS_X, 0), this.prefs.getInt(PREFS_Y, 0));
        }
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoginForm() {
        this.loginDialog.showDialog();
        if (!this.loginDialog.isCanceled()) {
            ClientSession clientSession = this.loginDialog.getClientSession();
            this.model.setClientSession(clientSession);
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.model.loadFolder(clientSession.getSession().getRepositoryInfo().getRootFolderId(), false);
                this.model.loadObject(clientSession.getSession().getRepositoryInfo().getRootFolderId());
                this.toolbarButton[1].setEnabled(true);
                this.toolbarButton[2].setEnabled(true);
                this.toolbarButton[3].setEnabled(this.model.supportsQuery());
                this.toolbarButton[4].setEnabled(this.model.supportsChangeLog());
                this.toolbarButton[5].setEnabled(true);
                this.toolbarButton[6].setEnabled(true);
                this.toolbarButton[7].setEnabled(true);
                this.toolbarButton[8].setEnabled(true);
                this.setTitle("CMIS Workbench - " + clientSession.getSession().getRepositoryInfo().getName());
            }
            catch (Exception ex) {
                this.toolbarButton[1].setEnabled(false);
                this.toolbarButton[2].setEnabled(false);
                this.toolbarButton[3].setEnabled(false);
                this.toolbarButton[4].setEnabled(false);
                this.toolbarButton[5].setEnabled(false);
                this.toolbarButton[6].setEnabled(false);
                this.toolbarButton[7].setEnabled(false);
                this.toolbarButton[8].setEnabled(false);
                ClientHelper.showError(null, ex);
                this.setTitle(WINDOW_TITLE);
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openConsole(String file) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            Console console = new Console(this.getClass().getClassLoader());
            console.setVariable("session", (Object)this.model.getClientSession().getSession());
            console.setVariable("binding", (Object)this.model.getClientSession().getSession().getBinding());
            console.run();
            JMenu cmisMenu = new JMenu("CMIS");
            console.getFrame().getRootPane().getJMenuBar().add(cmisMenu);
            this.addConsoleMenu(cmisMenu, "CMIS 1.0 Specification", new URI("http://docs.oasis-open.org/cmis/CMIS/v1.0/os/cmis-spec-v1.0.html"));
            this.addConsoleMenu(cmisMenu, "OpenCMIS Documentation", new URI("http://chemistry.apache.org/java/opencmis.html"));
            this.addConsoleMenu(cmisMenu, "OpenCMIS Client API JavaDoc", new URI("http://incubator.apache.org/chemistry/javadoc/org/apache/chemistry/opencmis/client/api/package-summary.html"));
            console.getInputArea().setText(ClientHelper.readFileAndRemoveHeader(file));
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void addConsoleMenu(JMenu menu, String title, final URI url) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            return;
        }
        JMenuItem menuItem = new JMenuItem(title);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(url);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        menu.add(menuItem);
    }

    private List<ClientHelper.FileEntry> readScriptLibrary() {
        List<ClientHelper.FileEntry> result = ClientHelper.readFileProperties("/scripts/script-library.properties", GROOVY_SCRIPT_FOLDER);
        if (result == null) {
            result = Collections.singletonList(new ClientHelper.FileEntry("Groovy Console", null));
        }
        return result;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        Point p = this.getLocation();
        this.prefs.putInt(PREFS_X, p.x);
        this.prefs.putInt(PREFS_Y, p.y);
        this.prefs.putInt(PREFS_WIDTH, this.getWidth());
        this.prefs.putInt(PREFS_HEIGHT, this.getHeight());
        this.prefs.putInt(PREFS_DIV, this.split.getDividerLocation());
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

