/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientHelper {
    public static final Color LINK_COLOR = new Color(105, 29, 21);
    public static final Color LINK_SELECTED_COLOR = new Color(255, 255, 255);
    private static final Log log = LogFactory.getLog(ClientHelper.class);
    private static final int BUFFER_SIZE = 65536;

    private ClientHelper() {
    }

    public static void showError(Component parent, Exception ex) {
        if (log.isErrorEnabled()) {
            log.error((Object)(ex.getClass().getSimpleName() + ": " + ex.getMessage()), (Throwable)ex);
            if (ex instanceof CmisBaseException) {
                CmisBaseException cex = (CmisBaseException)ex;
                if (cex.getCode() != null) {
                    log.error((Object)("Error code: " + cex.getCode()));
                }
                if (cex.getErrorContent() != null) {
                    log.error((Object)("Error content: " + cex.getErrorContent()));
                }
            }
        }
        String exceptionName = ex.getClass().getSimpleName();
        if (ex instanceof CmisBaseException) {
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        }
        JOptionPane.showMessageDialog(parent, exceptionName + ":\n" + ex.getMessage(), "Error", 0);
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").startsWith("Mac OS X");
    }

    public static void installKeyBindings() {
        if (ClientHelper.isMacOSX()) {
            KeyStroke copyKeyStroke = KeyStroke.getKeyStroke("meta pressed C");
            KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke("meta pressed V");
            KeyStroke cutKeyStroke = KeyStroke.getKeyStroke("meta pressed X");
            KeyStroke allKeyStroke = KeyStroke.getKeyStroke("meta pressed A");
            InputMap textFieldMap = (InputMap)UIManager.get("TextField.focusInputMap");
            textFieldMap.put(copyKeyStroke, "copy-to-clipboard");
            textFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
            textFieldMap.put(cutKeyStroke, "cut-to-clipboard");
            textFieldMap.put(allKeyStroke, "select-all");
            InputMap formattedTextFieldMap = (InputMap)UIManager.get("FormattedTextField.focusInputMap");
            formattedTextFieldMap.put(copyKeyStroke, "copy-to-clipboard");
            formattedTextFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
            formattedTextFieldMap.put(cutKeyStroke, "cut-to-clipboard");
            formattedTextFieldMap.put(allKeyStroke, "select-all");
            InputMap textAreaMap = (InputMap)UIManager.get("TextArea.focusInputMap");
            textAreaMap.put(copyKeyStroke, "copy-to-clipboard");
            textAreaMap.put(pasteKeyStroke, "paste-from-clipboard");
            textAreaMap.put(cutKeyStroke, "cut-to-clipboard");
            textAreaMap.put(allKeyStroke, "select-all");
            InputMap passwordFieldMap = (InputMap)UIManager.get("PasswordField.focusInputMap");
            passwordFieldMap.put(pasteKeyStroke, "paste-from-clipboard");
        }
    }

    public static ImageIcon getIcon(String name) {
        URL imageURL = ClientHelper.class.getResource("/images/" + name);
        if (imageURL != null) {
            return new ImageIcon(imageURL);
        }
        return null;
    }

    public static String getDateString(GregorianCalendar cal) {
        if (cal == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss ZZZ");
        return sdf.format(cal.getTime());
    }

    public static void download(Component component, CmisObject object, String streamId) {
        ContentStream content = ClientHelper.getContentStream(object, streamId);
        if (content == null) {
            return;
        }
        String filename = content.getFileName();
        if (filename == null) {
            filename = object instanceof Document ? ((Document)object).getContentStreamFileName() : object.getName();
        }
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(filename));
        int chooseResult = fileChooser.showDialog(component, "Download");
        if (chooseResult == 0) {
            try {
                ClientHelper.storeStream(content.getStream(), fileChooser.getSelectedFile());
            }
            catch (Exception e) {
                ClientHelper.showError(component, e);
            }
        }
    }

    public static void copy(Component component, File file) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setSelectedFile(new File(file.getName()));
        int chooseResult = fileChooser.showDialog(component, "Download");
        if (chooseResult == 0) {
            try {
                ClientHelper.storeStream(new FileInputStream(file), fileChooser.getSelectedFile());
            }
            catch (Exception e) {
                ClientHelper.showError(component, e);
            }
        }
    }

    public static void open(Component component, CmisObject object, String streamId) {
        if (!Desktop.isDesktopSupported()) {
            ClientHelper.download(component, object, streamId);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.OPEN)) {
            ClientHelper.download(component, object, streamId);
            return;
        }
        File file = null;
        try {
            file = ClientHelper.createTempFileFromDocument(object, streamId);
        }
        catch (Exception e) {
            ClientHelper.showError(component, e);
            return;
        }
        try {
            desktop.open(file);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                ClientHelper.copy(component, file);
            }
            ClientHelper.showError(component, e);
        }
    }

    public static File createTempFile(String filename) {
        String tempDir = System.getProperty("java.io.tmpdir");
        File clientTempDir = new File(tempDir, "cmisworkbench");
        if (!clientTempDir.exists()) {
            clientTempDir.mkdirs();
        }
        clientTempDir.deleteOnExit();
        File tempFile = new File(clientTempDir, filename);
        tempFile.deleteOnExit();
        return tempFile;
    }

    public static File createTempFileFromDocument(CmisObject object, String streamId) throws Exception {
        ContentStream content = ClientHelper.getContentStream(object, streamId);
        if (content == null) {
            throw new Exception("No content!");
        }
        String filename = content.getFileName();
        if ((filename == null || filename.length() == 0) && object instanceof Document) {
            filename = ((Document)object).getContentStreamFileName();
        }
        if (filename == null || filename.length() == 0) {
            filename = object.getName();
        }
        if (filename == null || filename.length() == 0) {
            filename = "content";
        }
        if (filename.indexOf(46) == -1) {
            filename = filename + MimeTypes.getExtension((String)content.getMimeType());
        }
        File tempFile = ClientHelper.createTempFile(filename);
        try {
            ClientHelper.storeStream(content.getStream(), tempFile);
        }
        catch (CmisConstraintException e) {
            // empty catch block
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeStream(InputStream in, File file) throws IOException {
        BufferedOutputStream out = null;
        try {
            int b;
            out = new BufferedOutputStream(new FileOutputStream(file), 65536);
            byte[] buffer = new byte[65536];
            while ((b = in.read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, b);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static ContentStream getContentStream(CmisObject object, String streamId) {
        if (object == null) {
            return null;
        }
        if (object instanceof Document) {
            return ((Document)object).getContentStream(streamId);
        }
        if (streamId == null) {
            return null;
        }
        List renditions = object.getRenditions();
        if (renditions == null) {
            return null;
        }
        for (Rendition rendition : renditions) {
            if (!streamId.equals(rendition.getStreamId())) continue;
            return rendition.getContentStream();
        }
        return null;
    }

    public static String readFileAndRemoveHeader(String file) {
        if (file == null) {
            return "";
        }
        InputStream stream = file.getClass().getResourceAsStream(file);
        if (stream == null) {
            return "";
        }
        try {
            String s;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            boolean header = true;
            while ((s = reader.readLine()) != null) {
                if (header) {
                    String st = s.trim();
                    if (st.length() == 0) {
                        header = false;
                        continue;
                    }
                    char c = st.charAt(0);
                    boolean bl = header = c == '/' || c == '*' || c == '#';
                    if (header) continue;
                }
                sb.append(s);
                sb.append("\n");
            }
            reader.close();
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FileEntry> readFileProperties(String propertiesFile, String path) {
        InputStream stream = propertiesFile.getClass().getResourceAsStream(propertiesFile);
        if (stream == null) {
            return null;
        }
        try {
            Properties properties = new Properties();
            properties.load(stream);
            stream.close();
            ArrayList<FileEntry> result = new ArrayList<FileEntry>();
            for (String file : properties.stringPropertyNames()) {
                result.add(new FileEntry(properties.getProperty(file), path + file));
            }
            Collections.sort(result);
            ArrayList<FileEntry> i$ = result;
            return i$;
        }
        catch (IOException e) {
            List<FileEntry> list = null;
            return list;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static class FileEntry
    implements Comparable<FileEntry> {
        private final String name;
        private final String file;

        public FileEntry(String name, String file) {
            this.name = name;
            this.file = file;
        }

        public String getName() {
            return this.name;
        }

        public String getFile() {
            return this.file;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(FileEntry o) {
            return this.name.compareToIgnoreCase(o.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FileEntry)) {
                return false;
            }
            return this.name.equals(((FileEntry)obj).getName());
        }
    }
}

