/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateDocumentDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JTextField nameField;
    private JComboBox typeBox;
    private JTextField filenameField;
    private JComboBox versioningStateBox;

    public CreateDocumentDialog(Frame owner, ClientModel model) {
        this(owner, model, null);
    }

    public CreateDocumentDialog(Frame owner, ClientModel model, File file) {
        super(owner, "Create Document", model);
        this.createGUI(file);
    }

    private void createGUI(File file) {
        final CreateDocumentDialog thisDialog = this;
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 0);
        this.typeBox = new JComboBox<Object>(this.getTypes(BaseTypeId.CMIS_DOCUMENT.value()));
        this.typeBox.setSelectedIndex(0);
        this.typeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DocumentTypeDefinition type = (DocumentTypeDefinition)((CreateDialog.ObjectTypeItem)CreateDocumentDialog.this.typeBox.getSelectedItem()).getObjectType();
                if (type.isVersionable().booleanValue()) {
                    CreateDocumentDialog.this.versioningStateBox.setSelectedItem(VersioningState.MAJOR);
                } else {
                    CreateDocumentDialog.this.versioningStateBox.setSelectedItem(VersioningState.NONE);
                }
            }
        });
        this.createRow("Type:", this.typeBox, 1);
        JPanel filePanel = new JPanel(new BorderLayout());
        this.filenameField = new JTextField(30);
        filePanel.add((Component)this.filenameField, "Center");
        JButton browseButton = new JButton("Browse");
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser fileChooser = new JFileChooser();
                int chooseResult = fileChooser.showDialog(CreateDocumentDialog.this.filenameField, "Select");
                if (chooseResult == 0 && fileChooser.getSelectedFile().isFile()) {
                    CreateDocumentDialog.this.setFile(fileChooser.getSelectedFile());
                }
            }
        });
        filePanel.add((Component)browseButton, "After");
        this.createRow("File:", filePanel, 2);
        this.versioningStateBox = new JComboBox<Object>(new Object[]{VersioningState.NONE, VersioningState.MAJOR, VersioningState.MINOR, VersioningState.CHECKEDOUT});
        if (((DocumentTypeDefinition)((CreateDialog.ObjectTypeItem)this.typeBox.getSelectedItem()).getObjectType()).isVersionable().booleanValue()) {
            this.versioningStateBox.setSelectedItem(VersioningState.MAJOR);
        } else {
            this.versioningStateBox.setSelectedItem(VersioningState.NONE);
        }
        this.createRow("Versioning State:", this.versioningStateBox, 3);
        JButton createButton = new JButton("Create Document");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateDocumentDialog.this.nameField.getText();
                String type = ((CreateDialog.ObjectTypeItem)CreateDocumentDialog.this.typeBox.getSelectedItem()).getObjectType().getId();
                String filename = CreateDocumentDialog.this.filenameField.getText();
                try {
                    CreateDocumentDialog.this.getClientModel().createDocument(name, type, filename, (VersioningState)CreateDocumentDialog.this.versioningStateBox.getSelectedItem());
                    CreateDocumentDialog.this.getClientModel().reloadFolder();
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
            }
        });
        this.createRow("", createButton, 4);
        if (file != null) {
            this.setFile(file);
        }
        this.showDialog();
    }

    private void setFile(File file) {
        this.filenameField.setText(file.getAbsolutePath());
        if (this.nameField.getText().trim().length() == 0) {
            this.nameField.setText(file.getName());
        }
    }
}

