/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.CreateDialog;

public class CreateFolderDialog
extends CreateDialog {
    private static final long serialVersionUID = 1L;
    private JTextField nameField;
    private JComboBox typeBox;

    public CreateFolderDialog(Frame owner, ClientModel model) {
        super(owner, "Create Folder", model);
        this.createGUI();
    }

    private void createGUI() {
        final CreateFolderDialog thisDialog = this;
        this.nameField = new JTextField(60);
        this.createRow("Name:", this.nameField, 0);
        this.typeBox = new JComboBox<Object>(this.getTypes(BaseTypeId.CMIS_FOLDER.value()));
        this.typeBox.setSelectedIndex(0);
        this.createRow("Type:", this.typeBox, 1);
        JButton createButton = new JButton("Create Folder");
        createButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String name = CreateFolderDialog.this.nameField.getText();
                String type = ((CreateDialog.ObjectTypeItem)CreateFolderDialog.this.typeBox.getSelectedItem()).getObjectType().getId();
                try {
                    CreateFolderDialog.this.getClientModel().createFolder(name, type);
                    CreateFolderDialog.this.getClientModel().reloadFolder();
                    thisDialog.setVisible(false);
                    thisDialog.dispose();
                }
                catch (Exception e) {
                    ClientHelper.showError(null, e);
                }
            }
        });
        this.createRow("", createButton, 3);
        this.showDialog();
    }
}

