/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.FolderTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;

public class FolderPanel
extends JPanel
implements FolderListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private String parentId;
    private JButton upButton;
    private JTextField pathField;
    private JButton goButton;
    private FolderTable folderTable;

    public FolderPanel(ClientModel model) {
        this.model = model;
        model.addFolderListener(this);
        this.createGUI();
    }

    @Override
    public void folderLoaded(ClientModelEvent event) {
        Folder currentFolder = event.getClientModel().getCurrentFolder();
        if (currentFolder != null) {
            String path = currentFolder.getPath();
            this.pathField.setText(path);
            Folder parent = currentFolder.getFolderParent();
            if (parent == null) {
                this.parentId = null;
                this.upButton.setEnabled(false);
            } else {
                this.parentId = parent.getId();
                this.upButton.setEnabled(true);
            }
        } else {
            this.pathField.setText("???");
            this.parentId = null;
            this.upButton.setEnabled(false);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        this.upButton = new JButton("up");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    FolderPanel.this.model.loadFolder(FolderPanel.this.parentId, false);
                    FolderPanel.this.model.loadObject(FolderPanel.this.model.getCurrentFolder().getId());
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    FolderPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        panel.add(this.upButton);
        this.pathField = new JTextField("");
        this.pathField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FolderPanel.this.loadFolder();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        panel.add(this.pathField);
        this.goButton = new JButton("go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FolderPanel.this.loadFolder();
            }
        });
        panel.add(this.goButton);
        this.add((Component)panel, "First");
        this.folderTable = new FolderTable(this.model);
        this.folderTable.setFillsViewportHeight(true);
        this.model.addFolderListener(this.folderTable);
        this.add((Component)new JScrollPane(this.folderTable), "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFolder() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String id = this.pathField.getText().trim();
            if (id.length() == 0) {
                id = "/";
            }
            this.model.loadFolder(id, id.startsWith("/"));
            this.model.loadObject(this.model.getCurrentFolder().getId());
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

