/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.CreateDocumentDialog;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;
import org.apache.chemistry.opencmis.workbench.swing.GregorianCalendarRenderer;

public class FolderTable
extends JTable
implements FolderListener {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"", "Name", "Type", "Content Type", "Size", "Creation Date", "Created by", "Modification Date", "Modified by", "Id"};
    private static final int[] COLUMN_WIDTHS = new int[]{24, 200, 150, 150, 80, 180, 100, 180, 100, 300};
    private static final int ID_COLUMN = 9;
    private final ClientModel model;
    private Map<BaseTypeId, ImageIcon> icons;

    public FolderTable(final ClientModel model) {
        this.model = model;
        this.setModel(new FolderTableModel());
        this.setSelectionMode(0);
        this.setAutoResizeMode(0);
        this.setAutoCreateRowSorter(true);
        this.setDefaultRenderer(GregorianCalendar.class, new GregorianCalendarRenderer());
        this.setTransferHandler(new FolderTransferHandler());
        this.setDragEnabled(true);
        this.setDropMode(DropMode.INSERT);
        for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
            TableColumn column = this.getColumnModel().getColumn(i);
            column.setPreferredWidth(COLUMN_WIDTHS[i]);
        }
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int row = FolderTable.this.getSelectedRow();
                if (row > -1) {
                    String id = FolderTable.this.getValueAt(row, 9).toString();
                    try {
                        FolderTable.this.setCursor(Cursor.getPredefinedCursor(3));
                        model.loadObject(id);
                    }
                    catch (Exception ex) {
                        ClientHelper.showError(null, ex);
                        return;
                    }
                    finally {
                        FolderTable.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FolderTable.this.doAction(e.isShiftDown());
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    FolderTable.this.doAction(e.isShiftDown());
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.loadIcons();
    }

    private void loadIcons() {
        this.icons = new HashMap<BaseTypeId, ImageIcon>();
        this.icons.put(BaseTypeId.CMIS_DOCUMENT, ClientHelper.getIcon("document.png"));
        this.icons.put(BaseTypeId.CMIS_FOLDER, ClientHelper.getIcon("folder.png"));
        this.icons.put(BaseTypeId.CMIS_RELATIONSHIP, ClientHelper.getIcon("relationship.png"));
        this.icons.put(BaseTypeId.CMIS_POLICY, ClientHelper.getIcon("policy.png"));
    }

    @Override
    public void folderLoaded(ClientModelEvent event) {
        event.getClientModel().getCurrentChildren();
        ((FolderTableModel)this.getModel()).fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAction(boolean alternate) {
        int row = this.getSelectedRow();
        if (row > -1 && row < this.model.getCurrentChildren().size()) {
            String id = this.getValueAt(row, 9).toString();
            CmisObject object = this.model.getFromCurrentChildren(id);
            if (object instanceof Document) {
                if (alternate) {
                    ClientHelper.download(this.getParent(), (CmisObject)((Document)object), null);
                } else {
                    ClientHelper.open(this.getParent(), (CmisObject)((Document)object), null);
                }
            } else if (object instanceof Folder) {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.model.loadFolder(object.getId(), false);
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                    return;
                }
                finally {
                    this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }
    }

    class FolderTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return false;
            }
            return support.isDrop();
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            File file = null;
            try {
                List fileList = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (fileList == null || fileList.size() != 1 || fileList.get(0) == null || !((File)fileList.get(0)).isFile()) {
                    return false;
                }
                file = (File)fileList.get(0);
            }
            catch (Exception ex) {
                ClientHelper.showError(null, ex);
                return false;
            }
            new CreateDocumentDialog(null, FolderTable.this.model, file);
            return true;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            int row = FolderTable.this.getSelectedRow();
            if (row > -1 && row < FolderTable.this.model.getCurrentChildren().size()) {
                String id = FolderTable.this.getValueAt(row, 9).toString();
                CmisObject object = FolderTable.this.model.getFromCurrentChildren(id);
                if (object instanceof Document) {
                    Document doc = (Document)object;
                    File tempFile = null;
                    try {
                        tempFile = ClientHelper.createTempFileFromDocument((CmisObject)doc, null);
                    }
                    catch (Exception e) {
                        ClientHelper.showError(null, e);
                    }
                    final File tempTransFile = tempFile;
                    return new Transferable(){

                        @Override
                        public boolean isDataFlavorSupported(DataFlavor flavor) {
                            return flavor == DataFlavor.javaFileListFlavor;
                        }

                        @Override
                        public DataFlavor[] getTransferDataFlavors() {
                            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
                        }

                        @Override
                        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                            return Collections.singletonList(tempTransFile);
                        }
                    };
                }
            }
            return null;
        }
    }

    class FolderTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        FolderTableModel() {
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public int getRowCount() {
            return FolderTable.this.model.getCurrentChildren().size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CmisObject obj = FolderTable.this.model.getCurrentChildren().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return FolderTable.this.icons.get(obj.getBaseTypeId());
                }
                case 1: {
                    return obj.getName();
                }
                case 2: {
                    return obj.getType().getId();
                }
                case 3: {
                    if (obj instanceof Document) {
                        return ((Document)obj).getContentStreamMimeType();
                    }
                    return null;
                }
                case 4: {
                    if (obj instanceof Document) {
                        return ((Document)obj).getContentStreamLength();
                    }
                    return null;
                }
                case 5: {
                    return obj.getCreationDate();
                }
                case 6: {
                    return obj.getCreatedBy();
                }
                case 7: {
                    return obj.getLastModificationDate();
                }
                case 8: {
                    return obj.getLastModifiedBy();
                }
                case 9: {
                    return obj.getId();
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageIcon.class;
                }
                case 4: {
                    return Long.class;
                }
                case 5: 
                case 7: {
                    return GregorianCalendar.class;
                }
            }
            return String.class;
        }
    }
}

