/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.apache.chemistry.opencmis.workbench.ClientHelper;

public class InfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public InfoDialog(Frame owner) {
        super(owner, "Info", true);
        this.createGUI();
    }

    private void createGUI() {
        this.setPreferredSize(new Dimension(800, 500));
        this.setMinimumSize(new Dimension(600, 400));
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel topPanel = new JPanel(new FlowLayout());
        JLabel cmisLogo = new JLabel(ClientHelper.getIcon("icon.png"));
        topPanel.add(cmisLogo);
        Font labelFont = UIManager.getFont("Label.font");
        Font titleFont = labelFont.deriveFont(1, labelFont.getSize2D() * 2.0f);
        JLabel titleLabel = new JLabel("CMIS Workbench");
        titleLabel.setFont(titleFont);
        topPanel.add(titleLabel);
        this.add(topPanel);
        StringBuilder readme = new StringBuilder();
        readme.append(this.loadText("/META-INF/README", "CMIS Workbench"));
        readme.append("\n---------------------------------------------------------\n");
        readme.append(this.loadText("/META-INF/build-timestamp.txt", ""));
        JTextArea ta = new JTextArea(readme.toString());
        ta.setEditable(false);
        ta.setFont(new Font("Monospaced", 0, 12));
        JScrollPane readmePane = new JScrollPane(ta);
        readmePane.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add(readmePane);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void showDialog() {
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    private String loadText(String file, String defaultText) {
        StringBuilder result = new StringBuilder();
        InputStream stream = this.getClass().getResourceAsStream(file);
        if (stream != null) {
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(stream));
                String s = null;
                while ((s = br.readLine()) != null) {
                    result.append(s);
                    result.append('\n');
                }
                br.close();
            }
            catch (Exception e) {}
        } else {
            result.append(defaultText);
        }
        return result.toString();
    }
}

