/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.chemistry.opencmis.workbench.ClientWriterAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class LogFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Client Logging";
    private JTextArea logTextArea;

    public LogFrame() {
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle(WINDOW_TITLE);
        this.setPreferredSize(new Dimension(800, 600));
        this.setMinimumSize(new Dimension(200, 60));
        this.setLayout(new BorderLayout());
        this.logTextArea = new JTextArea();
        this.logTextArea.setEditable(false);
        this.logTextArea.setFont(new Font("Monospaced", 0, 12));
        this.logTextArea.setLineWrap(true);
        this.logTextArea.setWrapStyleWord(true);
        this.add((Component)new JScrollPane(this.logTextArea), "Center");
        JPanel inputPanel = new JPanel(new FlowLayout());
        this.add((Component)inputPanel, "Last");
        JButton clearButton = new JButton("Clear");
        clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogFrame.this.logTextArea.setText("");
            }
        });
        inputPanel.add(clearButton);
        String[] levels = new String[]{Level.ALL.toString(), Level.TRACE.toString(), Level.DEBUG.toString(), Level.INFO.toString(), Level.WARN.toString(), Level.ERROR.toString(), Level.FATAL.toString(), Level.OFF.toString()};
        final JComboBox<String> levelBox = new JComboBox<String>(levels);
        levelBox.setSelectedItem(Logger.getRootLogger().getLevel().toString());
        levelBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Logger.getRootLogger().setLevel(Level.toLevel((String)levelBox.getSelectedItem().toString()));
            }
        });
        inputPanel.add(levelBox);
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(false);
        ClientWriterAppender.setTextArea(this.logTextArea);
    }

    public void showFrame() {
        this.setVisible(true);
    }
}

