/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;

public class LoginDialog
extends JDialog {
    public static final String SYSPROP_URL = "cmis.workbench.url";
    public static final String SYSPROP_BINDING = "cmis.workbench.binding";
    public static final String SYSPROP_AUTHENTICATION = "cmis.workbench.authentication";
    public static final String SYSPROP_COMPRESSION = "cmis.workbench.compression";
    public static final String SYSPROP_USER = "cmis.workbench.user";
    public static final String SYSPROP_PASSWORD = "cmis.workbench.password";
    private static final String CONFIGS_FOLDER = "/configs/";
    private static final String CONFIGS_LIBRARY = "config-library.properties";
    private static final long serialVersionUID = 1L;
    private JTabbedPane loginTabs;
    private JTextField urlField;
    private JRadioButton bindingAtomButton;
    private JRadioButton bindingWebServicesButton;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private JRadioButton authenticationNoneButton;
    private JRadioButton authenticationStandardButton;
    private JRadioButton authenticationNTLMButton;
    private JRadioButton compressionOnButton;
    private JRadioButton compressionOffButton;
    private JTextArea sessionParameterTextArea;
    private JButton loadRepositoryButton;
    private JButton loginButton;
    private JComboBox repositoryBox;
    private List<ClientHelper.FileEntry> sessionConfigurations;
    private boolean expertLogin = false;
    private boolean canceled = true;
    private ClientSession clientSession;

    public LoginDialog(Frame owner) {
        super(owner, "Login", true);
        this.createGUI();
    }

    private void createGUI() {
        this.setMinimumSize(new Dimension(700, 500));
        this.setPreferredSize(new Dimension(700, 500));
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.loginTabs = new JTabbedPane();
        this.add((Component)this.loginTabs, "Center");
        JPanel basicPanel = new JPanel(new SpringLayout());
        this.urlField = this.createTextField(basicPanel, "URL:");
        this.urlField.setText(System.getProperty(SYSPROP_URL, ""));
        this.createBindingButtons(basicPanel);
        this.usernameField = this.createTextField(basicPanel, "Username:");
        this.usernameField.setText(System.getProperty(SYSPROP_USER, ""));
        this.passwordField = this.createPasswordField(basicPanel, "Password:");
        this.passwordField.setText(System.getProperty(SYSPROP_PASSWORD, ""));
        this.createAuthenticationButtons(basicPanel);
        this.createCompressionButtons(basicPanel);
        this.makeCompactGrid(basicPanel, 6, 2, 5, 10, 5, 5);
        this.loginTabs.addTab("Basic", basicPanel);
        final JPanel expertPanel = new JPanel(new BorderLayout());
        expertPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.sessionConfigurations = ClientHelper.readFileProperties("/configs/config-library.properties", CONFIGS_FOLDER);
        final JComboBox<ClientHelper.FileEntry> configs = new JComboBox<ClientHelper.FileEntry>();
        configs.setMaximumRowCount(20);
        configs.addItem(new ClientHelper.FileEntry("", null));
        if (this.sessionConfigurations != null) {
            for (ClientHelper.FileEntry fe : this.sessionConfigurations) {
                configs.addItem(fe);
            }
        }
        expertPanel.add(configs, "First");
        this.sessionParameterTextArea = new JTextArea();
        this.sessionParameterTextArea.setFont(new Font("Monospaced", 0, 12));
        expertPanel.add((Component)new JScrollPane(this.sessionParameterTextArea), "Center");
        this.loginTabs.addTab("Expert", expertPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 3));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.add((Component)buttonPanel, "Last");
        this.loadRepositoryButton = this.createButton("Load Repositories");
        buttonPanel.add(this.loadRepositoryButton);
        this.createRepositoryBox(buttonPanel);
        this.loginButton = this.createButton("Login");
        buttonPanel.add(this.loginButton);
        this.loginButton.setEnabled(false);
        this.loadRepositoryButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                LoginDialog.this.repositoryBox.removeAllItems();
                try {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    LoginDialog.this.createClientSession();
                    List<Repository> repositories = LoginDialog.this.clientSession.getRepositories();
                    if (repositories.size() > 0) {
                        for (Repository repository : repositories) {
                            LoginDialog.this.repositoryBox.addItem(repository);
                        }
                        LoginDialog.this.repositoryBox.setEnabled(true);
                        LoginDialog.this.loginButton.setEnabled(true);
                    } else {
                        LoginDialog.this.repositoryBox.setEnabled(false);
                        LoginDialog.this.loginButton.setEnabled(false);
                    }
                }
                catch (Exception ex) {
                    LoginDialog.this.repositoryBox.setEnabled(false);
                    LoginDialog.this.loginButton.setEnabled(false);
                    ClientHelper.showError(LoginDialog.this.getOwner(), ex);
                }
                finally {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    LoginDialog.this.clientSession.createSession(LoginDialog.this.repositoryBox.getSelectedIndex());
                    LoginDialog.this.canceled = false;
                    LoginDialog.this.hideDialog();
                }
                catch (Exception ex) {
                    LoginDialog.this.repositoryBox.setEnabled(false);
                    LoginDialog.this.loginButton.setEnabled(false);
                    ClientHelper.showError(LoginDialog.this.getOwner(), ex);
                }
                finally {
                    LoginDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.loginTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                LoginDialog.this.expertLogin = LoginDialog.this.loginTabs.getSelectedComponent() == expertPanel;
                if (LoginDialog.this.expertLogin) {
                    configs.setSelectedIndex(0);
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry parameter : LoginDialog.this.createBasicSessionParameters().entrySet()) {
                        sb.append((String)parameter.getKey());
                        sb.append("=");
                        sb.append((String)parameter.getValue());
                        sb.append("\n");
                    }
                    LoginDialog.this.sessionParameterTextArea.setText(sb.toString());
                    LoginDialog.this.sessionParameterTextArea.setCaretPosition(0);
                }
            }
        });
        configs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ClientHelper.FileEntry fe = (ClientHelper.FileEntry)e.getItem();
                LoginDialog.this.sessionParameterTextArea.setText(ClientHelper.readFileAndRemoveHeader(fe.getFile()));
                LoginDialog.this.sessionParameterTextArea.setCaretPosition(0);
            }
        });
        this.setDefaultCloseOperation(1);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private JTextField createTextField(Container pane, String label) {
        JTextField textField = new JTextField(60);
        JLabel textLabel = new JLabel(label, 11);
        textLabel.setLabelFor(textField);
        pane.add(textLabel);
        pane.add(textField);
        return textField;
    }

    private JPasswordField createPasswordField(Container pane, String label) {
        JPasswordField textField = new JPasswordField(60);
        JLabel textLabel = new JLabel(label, 11);
        textLabel.setLabelFor(textField);
        pane.add(textLabel);
        pane.add(textField);
        return textField;
    }

    private void createBindingButtons(Container pane) {
        JPanel bindingContainer = new JPanel();
        bindingContainer.setLayout(new BoxLayout(bindingContainer, 2));
        boolean atom = System.getProperty(SYSPROP_BINDING, "atom").toLowerCase().charAt(0) == 'a';
        this.bindingAtomButton = new JRadioButton("AtomPub", atom);
        this.bindingWebServicesButton = new JRadioButton("Web Services", !atom);
        ButtonGroup bindingGroup = new ButtonGroup();
        bindingGroup.add(this.bindingAtomButton);
        bindingGroup.add(this.bindingWebServicesButton);
        bindingContainer.add(this.bindingAtomButton);
        bindingContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        bindingContainer.add(this.bindingWebServicesButton);
        JLabel bindingLabel = new JLabel("Binding:", 11);
        pane.add(bindingLabel);
        pane.add(bindingContainer);
    }

    private void createAuthenticationButtons(Container pane) {
        JPanel authenticationContainer = new JPanel();
        authenticationContainer.setLayout(new BoxLayout(authenticationContainer, 2));
        boolean standard = System.getProperty(SYSPROP_AUTHENTICATION, "standard").toLowerCase().equals("standard");
        boolean ntlm = System.getProperty(SYSPROP_AUTHENTICATION, "").toLowerCase().equals("ntlm");
        boolean none = !standard && !ntlm;
        this.authenticationNoneButton = new JRadioButton("None", none);
        this.authenticationStandardButton = new JRadioButton("Standard", standard);
        this.authenticationNTLMButton = new JRadioButton("NTLM", ntlm);
        ButtonGroup authenticationGroup = new ButtonGroup();
        authenticationGroup.add(this.authenticationNoneButton);
        authenticationGroup.add(this.authenticationStandardButton);
        authenticationGroup.add(this.authenticationNTLMButton);
        authenticationContainer.add(this.authenticationNoneButton);
        authenticationContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        authenticationContainer.add(this.authenticationStandardButton);
        authenticationContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        authenticationContainer.add(this.authenticationNTLMButton);
        JLabel authenticatioLabel = new JLabel("Authentication:", 11);
        pane.add(authenticatioLabel);
        pane.add(authenticationContainer);
    }

    private void createCompressionButtons(Container pane) {
        JPanel compressionContainer = new JPanel();
        compressionContainer.setLayout(new BoxLayout(compressionContainer, 2));
        boolean compression = !System.getProperty(SYSPROP_BINDING, "compression").equalsIgnoreCase("off");
        this.compressionOnButton = new JRadioButton("On", compression);
        this.compressionOffButton = new JRadioButton("Off", !compression);
        ButtonGroup compressionGroup = new ButtonGroup();
        compressionGroup.add(this.compressionOnButton);
        compressionGroup.add(this.compressionOffButton);
        compressionContainer.add(this.compressionOnButton);
        compressionContainer.add(Box.createRigidArea(new Dimension(10, 0)));
        compressionContainer.add(this.compressionOffButton);
        JLabel compressionLabel = new JLabel("Compression:", 11);
        pane.add(compressionLabel);
        pane.add(compressionContainer);
    }

    private JButton createButton(String title) {
        JButton button = new JButton(title);
        button.setPreferredSize(new Dimension(Short.MAX_VALUE, 30));
        button.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        button.setAlignmentX(0.5f);
        return button;
    }

    private void createRepositoryBox(Container pane) {
        this.repositoryBox = new JComboBox();
        this.repositoryBox.setEnabled(false);
        this.repositoryBox.setRenderer(new RepositoryRenderer());
        this.repositoryBox.setPreferredSize(new Dimension(Short.MAX_VALUE, 60));
        this.repositoryBox.setAlignmentX(0.5f);
        pane.add(this.repositoryBox);
    }

    private SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    private void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Spring x = Spring.constant(initialX);
        for (int c = 0; c < cols; ++c) {
            int r;
            Spring width = Spring.constant(0);
            for (r = 0; r < rows; ++r) {
                width = Spring.max(width, this.getConstraintsForCell(r, c, parent, cols).getWidth());
            }
            for (r = 0; r < rows; ++r) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
        }
        Spring y = Spring.constant(initialY);
        for (int r = 0; r < rows; ++r) {
            int c;
            Spring height = Spring.constant(0);
            for (c = 0; c < cols; ++c) {
                height = Spring.max(height, this.getConstraintsForCell(r, c, parent, cols).getHeight());
            }
            for (c = 0; c < cols; ++c) {
                SpringLayout.Constraints constraints = this.getConstraintsForCell(r, c, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
        }
        layout.getConstraints(parent).setConstraint("East", x);
    }

    private Map<String, String> createBasicSessionParameters() {
        String url = this.urlField.getText();
        BindingType binding = this.bindingAtomButton.isSelected() ? BindingType.ATOMPUB : BindingType.WEBSERVICES;
        String username = this.usernameField.getText();
        String password = new String(this.passwordField.getPassword());
        ClientSession.Authentication authentication = ClientSession.Authentication.NONE;
        if (this.authenticationStandardButton.isSelected()) {
            authentication = ClientSession.Authentication.STANDARD;
        } else if (this.authenticationNTLMButton.isSelected()) {
            authentication = ClientSession.Authentication.NTLM;
        }
        return ClientSession.createSessionParameters(url, binding, username, password, authentication, this.compressionOnButton.isSelected());
    }

    private Map<String, String> createExpertSessionParameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : this.sessionParameterTextArea.getText().split("\n")) {
            if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
            int x = line.indexOf(61);
            if (x < 0) {
                result.put(line.trim(), "");
                continue;
            }
            result.put(line.substring(0, x).trim(), line.substring(x + 1).trim());
        }
        return result;
    }

    public void createClientSession() {
        this.clientSession = this.expertLogin ? new ClientSession(this.createExpertSessionParameters()) : new ClientSession(this.createBasicSessionParameters());
    }

    public void showDialog() {
        this.clientSession = null;
        this.canceled = true;
        this.repositoryBox.removeAllItems();
        this.repositoryBox.setEnabled(false);
        this.loginButton.setEnabled(false);
        this.setLocationRelativeTo(this.getOwner());
        this.setVisible(true);
    }

    public void hideDialog() {
        this.setVisible(false);
    }

    public ClientSession getClientSession() {
        return this.clientSession;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    static class RepositoryRenderer
    extends JPanel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final JLabel nameLabel;
        private final JLabel idLabel;
        private final JLabel descriptionLabel;

        public RepositoryRenderer() {
            this.setLayout(new BoxLayout(this, 3));
            this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            Font labelFont = UIManager.getFont("Label.font");
            this.nameLabel = new JLabel();
            this.nameLabel.setFont(labelFont.deriveFont(1));
            this.add(this.nameLabel);
            this.idLabel = new JLabel();
            this.add(this.idLabel);
            this.descriptionLabel = new JLabel();
            this.add(this.descriptionLabel);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Repository repository = (Repository)value;
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (repository == null) {
                this.nameLabel.setText("");
                this.idLabel.setText("");
                this.descriptionLabel.setText("");
            } else {
                this.nameLabel.setText(repository.getName());
                this.idLabel.setText(repository.getId());
                this.descriptionLabel.setText(repository.getDescription());
            }
            return this;
        }
    }
}

