/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.NumberFormatter;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class QueryFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Query";
    private static final String DEFAULT_QUERY = "SELECT * FROM cmis:document";
    private final ClientModel model;
    private JTextArea queryText;
    private JFormattedTextField maxHitsField;
    private JCheckBox searchAllVersionsCheckBox;
    private JTable resultsTable;
    private JLabel queryTimeLabel;

    public QueryFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("CMIS Query - " + this.model.getRepositoryName());
        this.setPreferredSize(new Dimension(800, 700));
        this.setMinimumSize(new Dimension(200, 60));
        this.setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel inputPanel = new JPanel();
        inputPanel.setLayout(new BoxLayout(inputPanel, 2));
        this.queryText = new JTextArea(DEFAULT_QUERY, 5, 60);
        inputPanel.add(this.queryText);
        JPanel inputPanel2 = new JPanel();
        inputPanel2.setPreferredSize(new Dimension(160, 100));
        inputPanel2.setMaximumSize(inputPanel.getPreferredSize());
        inputPanel2.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        JButton queryButton = new JButton("Query");
        queryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryFrame.this.doQuery();
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        inputPanel2.add((Component)queryButton, c);
        this.maxHitsField = new JFormattedTextField(new NumberFormatter());
        this.maxHitsField.setValue(100);
        this.maxHitsField.setColumns(5);
        JLabel maxHitsLabel = new JLabel("Max hits:");
        maxHitsLabel.setLabelFor(this.maxHitsField);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        inputPanel2.add((Component)maxHitsLabel, c);
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 1;
        inputPanel2.add((Component)this.maxHitsField, c);
        this.searchAllVersionsCheckBox = new JCheckBox("search all versions", false);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        inputPanel2.add((Component)this.searchAllVersionsCheckBox, c);
        this.queryTimeLabel = new JLabel("(-- hits in -- seconds)");
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        inputPanel2.add((Component)this.queryTimeLabel, c);
        inputPanel.add(inputPanel2);
        this.resultsTable = new JTable();
        this.resultsTable.setFillsViewportHeight(true);
        this.resultsTable.setAutoResizeMode(0);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Copy to clipboard");
        popup.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StringBuilder sb = new StringBuilder();
                int rows = QueryFrame.this.resultsTable.getModel().getColumnCount();
                for (int row = 0; row < rows; ++row) {
                    int cols = QueryFrame.this.resultsTable.getModel().getColumnCount();
                    for (int col = 0; col < cols; ++col) {
                        sb.append(QueryFrame.this.resultsTable.getModel().getValueAt(row, col));
                        sb.append("|");
                    }
                    sb.append("\n");
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection transferable = new StringSelection(sb.toString());
                clipboard.setContents(transferable, null);
            }
        });
        this.resultsTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybeShowPopup(e);
            }

            private void maybeShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this.add(new JSplitPane(0, inputPanel, new JScrollPane(this.resultsTable)));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doQuery() {
        String text = this.queryText.getText();
        text = text.replace('\n', ' ');
        ItemIterable<QueryResult> results = null;
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            int maxHits = 1000;
            try {
                this.maxHitsField.commitEdit();
                maxHits = ((Number)this.maxHitsField.getValue()).intValue();
            }
            catch (Exception e) {
                // empty catch block
            }
            results = this.model.query(text, this.searchAllVersionsCheckBox.isSelected(), maxHits);
            ResultTableModel rtm = new ResultTableModel();
            long startTime = System.currentTimeMillis();
            int row = 0;
            for (QueryResult qr : results.getPage(maxHits)) {
                rtm.setColumnCount(Math.max(rtm.getColumnCount(), qr.getProperties().size()));
                for (PropertyData prop : qr.getProperties()) {
                    rtm.setValue(row, prop.getQueryName(), prop.getFirstValue());
                }
                ++row;
            }
            rtm.setRowCount(row);
            long stopTime = System.currentTimeMillis();
            float time = (float)(stopTime - startTime) / 1000.0f;
            this.queryTimeLabel.setText("(" + row + " hits in " + time + " seconds)");
            this.resultsTable.setModel(rtm);
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    static class ResultTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private int columnCount = 0;
        private int rowCount = 0;
        private final Map<String, Integer> columnMapping = new HashMap<String, Integer>();
        private final Map<Integer, Map<Integer, Object>> data = new HashMap<Integer, Map<Integer, Object>>();
        private final Map<Integer, Class<?>> columnClass = new HashMap();

        public void setColumnCount(int columnCount) {
            this.columnCount = columnCount;
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        public void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        public void setValue(int rowIndex, String queryName, Object value) {
            Integer col = this.columnMapping.get(queryName);
            if (col == null) {
                col = this.columnMapping.size();
                this.columnMapping.put(queryName, this.columnMapping.size());
            }
            if (value == null) {
                return;
            }
            if (value instanceof GregorianCalendar) {
                value = ClientHelper.getDateString((GregorianCalendar)value);
            }
            this.columnClass.put(col, value.getClass());
            Map<Integer, Object> row = this.data.get(rowIndex);
            if (row == null) {
                row = new HashMap<Integer, Object>();
                this.data.put(rowIndex, row);
            }
            row.put(col, value);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map<Integer, Object> row = this.data.get(rowIndex);
            if (row == null) {
                return null;
            }
            return row.get(columnIndex);
        }

        @Override
        public String getColumnName(int column) {
            for (Map.Entry<String, Integer> e : this.columnMapping.entrySet()) {
                if (!e.getValue().equals(column)) continue;
                return e.getKey();
            }
            return "?";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> clazz = this.columnClass.get(columnIndex);
            if (clazz != null) {
                return clazz;
            }
            return String.class;
        }
    }
}

