/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.chemistry.opencmis.commons.data.PermissionMapping;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PermissionDefinition;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;

public class RepositoryInfoFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Repository Info";
    private final ClientModel model;

    public RepositoryInfoFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
    }

    private void createGUI() {
        this.setTitle("CMIS Repository Info - " + this.model.getRepositoryName());
        this.setPreferredSize(new Dimension(700, 700));
        this.setMinimumSize(new Dimension(200, 60));
        RepositoryInfo repInfo = null;
        try {
            repInfo = this.model.getRepositoryInfo();
        }
        catch (Exception e) {
            ClientHelper.showError(this, e);
            this.dispose();
            return;
        }
        this.add(new JScrollPane(new RepositoryInfoPanel(repInfo)));
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    static class RepositoryInfoPanel
    extends InfoPanel {
        private static final long serialVersionUID = 1L;
        private final RepositoryInfo repInfo;

        public RepositoryInfoPanel(RepositoryInfo repInfo) {
            this.repInfo = repInfo;
            this.createGUI();
        }

        private void createGUI() {
            RepositoryCapabilities cap;
            this.setupGUI();
            this.addLine("Name:", true).setText(this.repInfo.getName());
            this.addLine("Id:").setText(this.repInfo.getId());
            this.addLine("Description:").setText(this.repInfo.getDescription());
            this.addLine("Vendor:").setText(this.repInfo.getVendorName());
            this.addLine("Product:").setText(this.repInfo.getProductName() + " " + this.repInfo.getProductVersion());
            this.addLine("CMIS Version:").setText(this.repInfo.getCmisVersionSupported());
            this.addLine("Root folder Id:").setText(this.repInfo.getRootFolderId());
            this.addLine("Latest change token:").setText(this.repInfo.getLatestChangeLogToken());
            this.addLine("Thin client URI:").setText(this.repInfo.getThinClientUri());
            this.addLine("Principal id anonymous:").setText(this.repInfo.getPrincipalIdAnonymous());
            this.addLine("Principal id anyone:").setText(this.repInfo.getPrincipalIdAnyone());
            this.addCheckBox("Changes incomplete:").setSelected(this.is(this.repInfo.getChangesIncomplete()));
            this.addLine("Changes on type:").setText(this.repInfo.getChangesOnType() == null ? "" : this.repInfo.getChangesOnType().toString());
            if (this.repInfo.getCapabilities() != null) {
                cap = this.repInfo.getCapabilities();
                this.addLine("Capabilities", true).setText("");
                this.addCheckBox("Get descendants supported:").setSelected(this.is(cap.isGetDescendantsSupported()));
                this.addCheckBox("Get folder tree supported:").setSelected(this.is(cap.isGetFolderTreeSupported()));
                this.addCheckBox("Unfiling supported:").setSelected(this.is(cap.isUnfilingSupported()));
                this.addCheckBox("Multifiling supported:").setSelected(this.is(cap.isMultifilingSupported()));
                this.addCheckBox("Version specific filing supported:").setSelected(this.is(cap.isVersionSpecificFilingSupported()));
                this.addLine("Query:").setText(this.str(cap.getQueryCapability()));
                this.addLine("Joins:").setText(this.str(cap.getJoinCapability()));
                this.addCheckBox("All versions searchable:").setSelected(this.is(cap.isAllVersionsSearchableSupported()));
                this.addCheckBox("PWC searchable:").setSelected(this.is(cap.isPwcSearchableSupported()));
                this.addCheckBox("PWC updatable:").setSelected(this.is(cap.isPwcUpdatableSupported()));
                this.addLine("Content stream updates:").setText(this.str(cap.getContentStreamUpdatesCapability()));
                this.addLine("Renditions:").setText(this.str(cap.getRenditionsCapability()));
                this.addLine("Changes:").setText(this.str(cap.getChangesCapability()));
                this.addLine("ACLs:").setText(this.str(cap.getAclCapability()));
            }
            if (this.repInfo.getAclCapabilities() != null) {
                int i;
                Object[][] data;
                cap = this.repInfo.getAclCapabilities();
                this.addLine("ACL Capabilities", true).setText("");
                this.addLine("Supported permissions:").setText(this.str(cap.getSupportedPermissions()));
                this.addLine("ACL propagation:").setText(this.str(cap.getAclPropagation()));
                if (cap.getPermissions() != null) {
                    data = new String[cap.getPermissions().size()][2];
                    i = 0;
                    for (PermissionDefinition pd : cap.getPermissions()) {
                        data[i][0] = pd.getId();
                        data[i][1] = pd.getDescription();
                        ++i;
                    }
                    JTable permTable = new JTable(data, new String[]{"Permission", "Description"});
                    permTable.setFillsViewportHeight(true);
                    this.addComponent("Permissions", new JScrollPane(permTable));
                }
                if (cap.getPermissionMapping() != null) {
                    data = new String[cap.getPermissionMapping().size()][2];
                    i = 0;
                    for (PermissionMapping pm : cap.getPermissionMapping().values()) {
                        data[i][0] = pm.getKey();
                        data[i][1] = pm.getPermissions() == null ? "" : pm.getPermissions().toString();
                        ++i;
                    }
                    JTable permMapTable = new JTable(data, new String[]{"Key", "Permissions"});
                    permMapTable.setFillsViewportHeight(true);
                    this.addComponent("Permission mapping", new JScrollPane(permMapTable));
                }
            }
        }

        private boolean is(Boolean b) {
            if (b == null) {
                return false;
            }
            return b;
        }

        private String str(Object o) {
            if (o == null) {
                return "?";
            }
            return o.toString();
        }
    }
}

