/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.CmisTestProgressMonitor;
import org.apache.chemistry.opencmis.tck.report.HtmlReport;
import org.apache.chemistry.opencmis.tck.runner.AbstractRunner;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class TckDialog {
    private final Frame owner;
    private final TckDialogRunner runner;
    private JProgressBar groupsProgressBar;
    private JProgressBar testsProgressBar;

    public TckDialog(Frame owner, ClientModel model) {
        this.owner = owner;
        this.runner = new TckDialogRunner(model);
        try {
            this.runner.loadDefaultTckGroups();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(owner, "Error: " + e.getMessage(), "TCK Error", 0);
            return;
        }
        JOptionPane.showMessageDialog(owner, "The TCK is brand new and incomplete. Don't trust the results, yet!", "TCK Warning", 2);
        new TckSelectDialog();
    }

    class TckTask
    extends SwingWorker<Void, Void> {
        private final JDialog dialog;
        private final TckDialogRunner runner;

        public TckTask(JDialog dialog, TckDialogRunner runner) {
            this.dialog = dialog;
            this.runner = runner;
        }

        @Override
        public Void doInBackground() {
            try {
                this.runner.run(new DialogProgressMonitor(this.runner.getGroups().size()));
            }
            catch (InterruptedException ie) {
                this.runner.cancel();
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TckDialog.this.owner, "Error: " + e.getMessage(), "TCK Error", 0);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            try {
                File tempReportFile = File.createTempFile("cmistck", ".html");
                tempReportFile.deleteOnExit();
                HtmlReport report = new HtmlReport();
                report.createReport(this.runner.getParameters(), this.runner.getGroups(), tempReportFile);
                Desktop desktop = Desktop.getDesktop();
                if (!desktop.isSupported(Desktop.Action.OPEN)) {
                    JOptionPane.showMessageDialog(TckDialog.this.owner, "Report: " + tempReportFile.getAbsolutePath(), "Report", 1);
                } else {
                    desktop.open(tempReportFile);
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(TckDialog.this.owner, "Error: " + e.getMessage(), "Report Error", 0);
            }
            finally {
                this.dialog.dispose();
            }
        }
    }

    private class DialogProgressMonitor
    implements CmisTestProgressMonitor {
        public DialogProgressMonitor(int numberOfGroups) {
            TckDialog.this.groupsProgressBar.setStringPainted(true);
            TckDialog.this.groupsProgressBar.setMinimum(0);
            TckDialog.this.groupsProgressBar.setMaximum(numberOfGroups);
            TckDialog.this.groupsProgressBar.setValue(0);
        }

        public void startGroup(CmisTestGroup group) {
            TckDialog.this.groupsProgressBar.setString(group.getName());
            TckDialog.this.testsProgressBar.setStringPainted(true);
            TckDialog.this.testsProgressBar.setMinimum(0);
            TckDialog.this.testsProgressBar.setMaximum(group.getTests().size());
            TckDialog.this.testsProgressBar.setValue(0);
        }

        public void endGroup(CmisTestGroup group) {
            TckDialog.this.groupsProgressBar.setString("");
            TckDialog.this.groupsProgressBar.setValue(TckDialog.this.groupsProgressBar.getValue() + 1);
        }

        public void startTest(CmisTest test) {
            TckDialog.this.testsProgressBar.setString(test.getName());
        }

        public void endTest(CmisTest test) {
            TckDialog.this.testsProgressBar.setString("");
            TckDialog.this.testsProgressBar.setValue(TckDialog.this.testsProgressBar.getValue() + 1);
        }

        public void message(String msg) {
        }
    }

    private static class TckDialogRunner
    extends AbstractRunner {
        public TckDialogRunner(ClientModel model) {
            HashMap<String, String> parameters = new HashMap<String, String>(model.getClientSession().getSessionParameters());
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", model.getClientSession().getSession().getRepositoryInfo().getId());
            this.setParameters(parameters);
        }
    }

    private class TckRunDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        private final TckTask task;

        public TckRunDialog() {
            super(TckDialog.this.owner, "TCK");
            this.createGUI();
            this.task = new TckTask(this, TckDialog.this.runner);
            this.task.execute();
        }

        private void createGUI() {
            this.setPreferredSize(new Dimension(500, 200));
            this.setMinimumSize(new Dimension(500, 200));
            this.setLayout(new BorderLayout());
            JPanel progressPanel = new JPanel();
            progressPanel.setLayout(new BoxLayout(progressPanel, 1));
            progressPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel groupsLabel = new JLabel("Groups:");
            groupsLabel.setAlignmentX(0.0f);
            progressPanel.add(groupsLabel);
            TckDialog.this.groupsProgressBar = new JProgressBar();
            TckDialog.this.groupsProgressBar.setMinimumSize(new Dimension(500, 30));
            TckDialog.this.groupsProgressBar.setPreferredSize(new Dimension(500, 30));
            TckDialog.this.groupsProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            TckDialog.this.groupsProgressBar.setAlignmentX(0.0f);
            TckDialog.this.groupsProgressBar.setAlignmentY(0.5f);
            progressPanel.add(TckDialog.this.groupsProgressBar);
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            JLabel testsLabel = new JLabel("Tests:");
            testsLabel.setAlignmentX(0.0f);
            progressPanel.add(testsLabel);
            TckDialog.this.testsProgressBar = new JProgressBar();
            TckDialog.this.testsProgressBar.setMinimumSize(new Dimension(500, 30));
            TckDialog.this.testsProgressBar.setPreferredSize(new Dimension(500, 30));
            TckDialog.this.testsProgressBar.setMaximumSize(new Dimension(Short.MAX_VALUE, 30));
            TckDialog.this.testsProgressBar.setAlignmentX(0.0f);
            TckDialog.this.testsProgressBar.setAlignmentY(0.5f);
            progressPanel.add(TckDialog.this.testsProgressBar);
            progressPanel.add(Box.createRigidArea(new Dimension(0, 10)));
            this.add((Component)progressPanel, "Center");
            JButton cancelButton = new JButton("Cancel");
            cancelButton.setDefaultCapable(true);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TckRunDialog.this.task.cancel(true);
                }
            });
            this.add((Component)cancelButton, "Last");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }

    private class TckSelectDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        public TckSelectDialog() {
            super(TckDialog.this.owner, "TCK", true);
            this.createGUI();
        }

        private void createGUI() {
            this.setPreferredSize(new Dimension(300, 500));
            this.setMinimumSize(new Dimension(300, 500));
            this.setLayout(new BorderLayout());
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Groups");
            for (CmisTestGroup group : TckDialog.this.runner.getGroups()) {
                DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group.getName());
                rootNode.add(groupNode);
                for (CmisTest test : group.getTests()) {
                    DefaultMutableTreeNode testNode = new DefaultMutableTreeNode(test.getName());
                    groupNode.add(testNode);
                }
            }
            JTree groupTree = new JTree(rootNode);
            groupTree.setRootVisible(false);
            for (int i = 0; i < groupTree.getRowCount(); ++i) {
                groupTree.expandRow(i);
            }
            this.add((Component)groupTree, "Center");
            JButton runButton = new JButton("Run TCK");
            runButton.setDefaultCapable(true);
            runButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    int answer = JOptionPane.showConfirmDialog(TckDialog.this.owner, "Running the TCK may take a long time and may add, remove and alter data in the repository!\nIt also puts at a strain on the repository, performing several thousand calls!\n\nAre you sure you want to proceed?", "TCK", 0, 2);
                    if (answer == 0) {
                        TckSelectDialog.this.dispose();
                        new TckRunDialog();
                    }
                }
            });
            this.add((Component)runButton, "Last");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }
    }
}

