/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.workbench.swing.CollectionRenderer;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;

public class TypeSplitPane
extends JSplitPane {
    private static final long serialVersionUID = 1L;
    private TypeInfoPanel typePanel;
    private PropertyDefinitionTable propertyDefinitionTable;

    public TypeSplitPane() {
        super(0);
        this.createGUI();
    }

    private void createGUI() {
        this.typePanel = new TypeInfoPanel();
        this.propertyDefinitionTable = new PropertyDefinitionTable();
        this.setLeftComponent(new JScrollPane(this.typePanel));
        this.setRightComponent(new JScrollPane(this.propertyDefinitionTable));
        this.setDividerLocation(300);
    }

    public void setType(ObjectType type) {
        this.typePanel.setType(type);
        this.propertyDefinitionTable.setType(type);
    }

    static class PropertyDefinitionTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private static final String[] COLUMN_NAMES = new String[]{"Name", "Id", "Description", "Local Namespace", "Local Name", "Query Name", "Type", "Cardinality", "Updatability", "Queryable", "Required", "Inherited", "Default Value", "Choices"};
        private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 200, 200, 200, 200, 80, 80, 80, 50, 50, 50, 200, 200};
        private ObjectType type;
        private List<PropertyDefinition<?>> propertyDefintions;

        public PropertyDefinitionTable() {
            this.setDefaultRenderer(Collection.class, new CollectionRenderer());
            this.setModel(new PropertyDefinitionTableModel(this));
            this.setAutoResizeMode(0);
            for (int i = 0; i < COLUMN_WIDTHS.length; ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(COLUMN_WIDTHS[i]);
            }
            this.setFillsViewportHeight(true);
        }

        public void setType(ObjectType type) {
            this.type = type;
            if (type != null && type.getPropertyDefinitions() != null) {
                this.propertyDefintions = new ArrayList();
                for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                    this.propertyDefintions.add(propDef);
                }
                Collections.sort(this.propertyDefintions, new Comparator<PropertyDefinition<?>>(){

                    @Override
                    public int compare(PropertyDefinition<?> pd1, PropertyDefinition<?> pd2) {
                        return pd1.getId().compareTo(pd2.getId());
                    }
                });
            } else {
                this.propertyDefintions = null;
            }
            ((AbstractTableModel)this.getModel()).fireTableDataChanged();
        }

        public ObjectType getType() {
            return this.type;
        }

        public List<PropertyDefinition<?>> getPropertyDefinitions() {
            return this.propertyDefintions;
        }

        static class PropertyDefinitionTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private final PropertyDefinitionTable table;

            public PropertyDefinitionTableModel(PropertyDefinitionTable table) {
                this.table = table;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return COLUMN_NAMES[columnIndex];
            }

            @Override
            public int getColumnCount() {
                return COLUMN_NAMES.length;
            }

            @Override
            public int getRowCount() {
                if (this.table.getPropertyDefinitions() == null) {
                    return 0;
                }
                return this.table.getPropertyDefinitions().size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                PropertyDefinition<?> propDef = this.table.getPropertyDefinitions().get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return propDef.getDisplayName();
                    }
                    case 1: {
                        return propDef.getId();
                    }
                    case 2: {
                        return propDef.getDescription();
                    }
                    case 3: {
                        return propDef.getLocalNamespace();
                    }
                    case 4: {
                        return propDef.getLocalName();
                    }
                    case 5: {
                        return propDef.getQueryName();
                    }
                    case 6: {
                        return propDef.getPropertyType();
                    }
                    case 7: {
                        return propDef.getCardinality();
                    }
                    case 8: {
                        return propDef.getUpdatability();
                    }
                    case 9: {
                        return propDef.isQueryable();
                    }
                    case 10: {
                        return propDef.isRequired();
                    }
                    case 11: {
                        return propDef.isInherited();
                    }
                    case 12: {
                        return propDef.getDefaultValue();
                    }
                    case 13: {
                        return propDef.getChoices();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 12 || columnIndex == 13) {
                    return Collection.class;
                }
                return super.getColumnClass(columnIndex);
            }
        }
    }

    static class TypeInfoPanel
    extends InfoPanel {
        private static final long serialVersionUID = 1L;
        private JTextField nameField;
        private JTextField descriptionField;
        private JTextField idField;
        private JTextField localNamespaceField;
        private JTextField localNameField;
        private JTextField queryNameField;
        private JTextField baseTypeField;
        private JCheckBox creatableBox;
        private JCheckBox fileableBox;
        private JCheckBox queryableBox;
        private JCheckBox aclBox;
        private JCheckBox policyBox;
        private JCheckBox versionableBox;
        private JTextField contentStreamAllowedField;
        private JTextField allowedSourceTypesField;
        private JTextField allowedTargetTypesField;

        public TypeInfoPanel() {
            this.createGUI();
        }

        public void setType(ObjectType type) {
            if (type != null) {
                this.nameField.setText(type.getDisplayName());
                this.descriptionField.setText(type.getDescription());
                this.idField.setText(type.getId());
                this.localNamespaceField.setText(type.getLocalNamespace());
                this.localNameField.setText(type.getLocalName());
                this.queryNameField.setText(type.getQueryName());
                this.baseTypeField.setText(type.getBaseTypeId().value());
                this.creatableBox.setSelected(this.is(type.isCreatable()));
                this.fileableBox.setSelected(this.is(type.isFileable()));
                this.queryableBox.setSelected(this.is(type.isQueryable()));
                this.aclBox.setSelected(this.is(type.isControllableAcl()));
                this.policyBox.setSelected(this.is(type.isControllablePolicy()));
                if (type instanceof DocumentTypeDefinition) {
                    DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
                    this.versionableBox.setVisible(true);
                    this.versionableBox.setSelected(this.is(docType.isVersionable()));
                    this.contentStreamAllowedField.setVisible(true);
                    this.contentStreamAllowedField.setText(docType.getContentStreamAllowed() == null ? "???" : docType.getContentStreamAllowed().toString());
                } else {
                    this.versionableBox.setVisible(false);
                    this.contentStreamAllowedField.setVisible(false);
                }
                if (type instanceof RelationshipTypeDefinition) {
                    RelationshipTypeDefinition relationshipType = (RelationshipTypeDefinition)type;
                    this.allowedSourceTypesField.setVisible(true);
                    this.allowedSourceTypesField.setText(relationshipType.getAllowedSourceTypeIds() == null ? "???" : relationshipType.getAllowedSourceTypeIds().toString());
                    this.allowedTargetTypesField.setVisible(true);
                    this.allowedTargetTypesField.setText(relationshipType.getAllowedTargetTypeIds() == null ? "???" : relationshipType.getAllowedTargetTypeIds().toString());
                } else {
                    this.allowedSourceTypesField.setVisible(false);
                    this.allowedTargetTypesField.setVisible(false);
                }
            } else {
                this.nameField.setText("");
                this.descriptionField.setText("");
                this.idField.setText("");
                this.localNamespaceField.setText("");
                this.localNameField.setText("");
                this.queryNameField.setText("");
                this.baseTypeField.setText("");
                this.creatableBox.setSelected(false);
                this.fileableBox.setSelected(false);
                this.queryableBox.setSelected(false);
                this.aclBox.setSelected(false);
                this.policyBox.setSelected(false);
                this.versionableBox.setVisible(false);
                this.contentStreamAllowedField.setVisible(false);
                this.allowedSourceTypesField.setVisible(false);
                this.allowedTargetTypesField.setVisible(false);
            }
            this.revalidate();
        }

        private void createGUI() {
            this.setupGUI();
            this.nameField = this.addLine("Name:", true);
            this.descriptionField = this.addLine("Description:");
            this.idField = this.addLine("Id:");
            this.localNamespaceField = this.addLine("Local Namespace:");
            this.localNameField = this.addLine("Local Name:");
            this.queryNameField = this.addLine("Query Name:");
            this.baseTypeField = this.addLine("Base Type:");
            this.creatableBox = this.addCheckBox("Creatable:");
            this.fileableBox = this.addCheckBox("Fileable:");
            this.queryableBox = this.addCheckBox("Queryable:");
            this.aclBox = this.addCheckBox("ACL controlable:");
            this.policyBox = this.addCheckBox("Policy controlable:");
            this.versionableBox = this.addCheckBox("Versionable:");
            this.contentStreamAllowedField = this.addLine("Content stream allowed:");
            this.allowedSourceTypesField = this.addLine("Allowed source types:");
            this.allowedTargetTypesField = this.addLine("Allowed target types:");
        }

        private boolean is(Boolean b) {
            if (b == null) {
                return false;
            }
            return b;
        }
    }
}

