/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.TypeSplitPane;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class TypesFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_TITLE = "CMIS Types";
    private final ClientModel model;
    private JTree typesTree;
    private TypeSplitPane typePanel;

    public TypesFrame(ClientModel model) {
        this.model = model;
        this.createGUI();
        this.loadData();
    }

    private void createGUI() {
        this.setTitle("CMIS Types - " + this.model.getRepositoryName());
        this.setPreferredSize(new Dimension(1000, 700));
        this.setMinimumSize(new Dimension(200, 60));
        this.typesTree = new JTree();
        this.typesTree.setRootVisible(false);
        this.typesTree.getSelectionModel().setSelectionMode(1);
        this.typesTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)((JTree)e.getSource()).getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ObjectType type = ((TypeNode)node.getUserObject()).getType();
                TypesFrame.this.typePanel.setType(type);
            }
        });
        this.typePanel = new TypeSplitPane();
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.typesTree), this.typePanel);
        splitPane.setDividerLocation(300);
        this.add(splitPane);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadData() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            List<Tree<ObjectType>> types = this.model.getTypeDescendants();
            for (Tree<ObjectType> tt : types) {
                this.addLevel(rootNode, tt);
            }
            DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
            this.typesTree.setModel(treeModel);
        }
        catch (Exception ex) {
            ClientHelper.showError(null, ex);
            return;
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void addLevel(DefaultMutableTreeNode parent, Tree<ObjectType> tree) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new TypeNode((ObjectType)tree.getItem()));
        parent.add(node);
        if (tree.getChildren() != null) {
            for (Tree tt : tree.getChildren()) {
                this.addLevel(node, (Tree<ObjectType>)tt);
            }
        }
    }

    static class TypeNode {
        private final ObjectType type;

        public TypeNode(ObjectType type) {
            this.type = type;
        }

        public ObjectType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.getDisplayName() + " (" + this.type.getId() + ")";
        }
    }
}

