/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.util.Collection;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class ACLTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Principal", "Permissions", "Direct"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 400, 50};

    public ACLTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public int getDetailRowCount() {
        if (this.getObject().getAcl() == null || this.getObject().getAcl().getAces() == null) {
            return 0;
        }
        return this.getObject().getAcl().getAces().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Ace ace = (Ace)this.getObject().getAcl().getAces().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ace.getPrincipalId();
            }
            case 1: {
                return ace.getPermissions();
            }
            case 2: {
                return ace.isDirect();
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 1) {
            return Collection.class;
        }
        if (columnIndex == 2) {
            return Boolean.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

