/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.workbench.actions.CancelCheckOutPanel;
import org.apache.chemistry.opencmis.workbench.actions.CheckInPanel;
import org.apache.chemistry.opencmis.workbench.actions.CheckOutPanel;
import org.apache.chemistry.opencmis.workbench.actions.DeleteContentStreamPanel;
import org.apache.chemistry.opencmis.workbench.actions.DeletePanel;
import org.apache.chemistry.opencmis.workbench.actions.DeleteTreePanel;
import org.apache.chemistry.opencmis.workbench.actions.MovePanel;
import org.apache.chemistry.opencmis.workbench.actions.PropertyUpdatePanel;
import org.apache.chemistry.opencmis.workbench.actions.SetContentStreamPanel;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class ActionsPanel
extends JPanel
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private PropertyUpdatePanel propertyUpdatePanel;
    private DeletePanel deletePanel;
    private DeleteTreePanel deleteTreePanel;
    private MovePanel movePanel;
    private CheckOutPanel checkOutPanel;
    private CancelCheckOutPanel cancelCheckOutPanel;
    private CheckInPanel checkInPanel;
    private SetContentStreamPanel setContentStreamPanel;
    private DeleteContentStreamPanel deleteContentStreamPanel;

    public ActionsPanel(ClientModel model) {
        this.model = model;
        model.addObjectListener(this);
        this.createGUI();
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        CmisObject object = this.model.getCurrentObject();
        this.propertyUpdatePanel.setObject(object);
        this.propertyUpdatePanel.setVisible(this.propertyUpdatePanel.isAllowed());
        this.deletePanel.setObject(object);
        this.deletePanel.setVisible(this.deletePanel.isAllowed());
        this.deleteTreePanel.setObject(object);
        this.deleteTreePanel.setVisible(this.deleteTreePanel.isAllowed());
        this.movePanel.setObject(object);
        this.movePanel.setVisible(this.movePanel.isAllowed());
        this.checkOutPanel.setObject(object);
        this.checkOutPanel.setVisible(this.checkOutPanel.isAllowed());
        this.cancelCheckOutPanel.setObject(object);
        this.cancelCheckOutPanel.setVisible(this.cancelCheckOutPanel.isAllowed());
        this.checkInPanel.setObject(object);
        this.checkInPanel.setVisible(this.checkInPanel.isAllowed());
        this.setContentStreamPanel.setObject(object);
        this.setContentStreamPanel.setVisible(this.setContentStreamPanel.isAllowed());
        this.deleteContentStreamPanel.setObject(object);
        this.deleteContentStreamPanel.setVisible(this.deleteContentStreamPanel.isAllowed());
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.propertyUpdatePanel = new PropertyUpdatePanel(this.model);
        this.add(this.propertyUpdatePanel);
        this.deletePanel = new DeletePanel(this.model);
        this.add(this.deletePanel);
        this.deleteTreePanel = new DeleteTreePanel(this.model);
        this.add(this.deleteTreePanel);
        this.movePanel = new MovePanel(this.model);
        this.add(this.movePanel);
        this.checkOutPanel = new CheckOutPanel(this.model);
        this.add(this.checkOutPanel);
        this.cancelCheckOutPanel = new CancelCheckOutPanel(this.model);
        this.add(this.cancelCheckOutPanel);
        this.checkInPanel = new CheckInPanel(this.model);
        this.add(this.checkInPanel);
        this.setContentStreamPanel = new SetContentStreamPanel(this.model);
        this.add(this.setContentStreamPanel);
        this.deleteContentStreamPanel = new DeleteContentStreamPanel(this.model);
        this.add(this.deleteContentStreamPanel);
    }
}

