/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.enums.ExtensionLevel;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class ExtensionsPanel
extends JPanel
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private JTree extensionsTree;

    public ExtensionsPanel(ClientModel model) {
        this.model = model;
        model.addObjectListener(this);
        this.createGUI();
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        CmisObject object = this.model.getCurrentObject();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        if (object != null) {
            List extensions = object.getExtensions(ExtensionLevel.OBJECT);
            if (extensions != null && !extensions.isEmpty()) {
                DefaultMutableTreeNode objectRootNode = new DefaultMutableTreeNode("Object");
                this.addExtension(objectRootNode, extensions);
                rootNode.add(objectRootNode);
            }
            if ((extensions = object.getExtensions(ExtensionLevel.PROPERTIES)) != null && !extensions.isEmpty()) {
                DefaultMutableTreeNode propertiesRootNode = new DefaultMutableTreeNode("Properties");
                this.addExtension(propertiesRootNode, extensions);
                rootNode.add(propertiesRootNode);
            }
            if ((extensions = object.getExtensions(ExtensionLevel.ALLOWABLE_ACTIONS)) != null && !extensions.isEmpty()) {
                DefaultMutableTreeNode allowableActionsRootNode = new DefaultMutableTreeNode("Allowable Actions");
                this.addExtension(allowableActionsRootNode, extensions);
                rootNode.add(allowableActionsRootNode);
            }
            if ((extensions = object.getExtensions(ExtensionLevel.ACL)) != null && !extensions.isEmpty()) {
                DefaultMutableTreeNode aclRootNode = new DefaultMutableTreeNode("ACL");
                this.addExtension(aclRootNode, extensions);
                rootNode.add(aclRootNode);
            }
            if ((extensions = object.getExtensions(ExtensionLevel.POLICIES)) != null && !extensions.isEmpty()) {
                DefaultMutableTreeNode policiesRootNode = new DefaultMutableTreeNode("Policies");
                this.addExtension(policiesRootNode, extensions);
                rootNode.add(policiesRootNode);
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.extensionsTree.setModel(treeModel);
    }

    private void addExtension(DefaultMutableTreeNode parent, List<CmisExtensionElement> extensions) {
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        for (CmisExtensionElement ext : extensions) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ExtensionNode(ext));
            parent.add(node);
            if (ext.getChildren().size() <= 0) continue;
            this.addExtension(node, ext.getChildren());
        }
    }

    private void createGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBackground(Color.WHITE);
        this.extensionsTree = new JTree();
        this.extensionsTree.setRootVisible(false);
        this.extensionsTree.getSelectionModel().setSelectionMode(1);
        this.extensionsTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.extensionsTree.setModel(new DefaultTreeModel(null));
        JScrollPane pane = new JScrollPane(this.extensionsTree);
        pane.setBorder(BorderFactory.createEmptyBorder());
        this.add(pane);
    }

    static class ExtensionNode {
        private final CmisExtensionElement extension;

        public ExtensionNode(CmisExtensionElement extension) {
            this.extension = extension;
        }

        public String toString() {
            return (this.extension.getNamespace() == null ? "" : "{" + this.extension.getNamespace() + "}") + this.extension.getName() + (!this.extension.getAttributes().isEmpty() ? " " + this.extension.getAttributes() : "") + (this.extension.getChildren().isEmpty() ? ": " + this.extension.getValue() : "");
        }
    }
}

