/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.LinkAccess;
import org.apache.chemistry.opencmis.workbench.ClientHelper;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;
import org.apache.chemistry.opencmis.workbench.swing.InfoPanel;

public class ObjectPanel
extends InfoPanel
implements ObjectListener {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private JTextField nameField;
    private JTextField idField;
    private JTextField typeField;
    private JTextField basetypeField;
    private JTextField versionLabelField;
    private JTextField contentUrlField;
    private InfoPanel.InfoList paths;
    private InfoPanel.InfoList allowableActionsList;
    private JButton refreshButton;

    public ObjectPanel(ClientModel model) {
        this.model = model;
        model.addObjectListener(this);
        this.createGUI();
    }

    @Override
    public void objectLoaded(ClientModelEvent event) {
        CmisObject object = this.model.getCurrentObject();
        if (object == null) {
            this.nameField.setText("");
            this.idField.setText("");
            this.typeField.setText("");
            this.basetypeField.setText("");
            this.versionLabelField.setText("");
            this.paths.removeAll();
            this.contentUrlField.setText("");
            this.allowableActionsList.removeAll();
            this.refreshButton.setEnabled(false);
        } else {
            try {
                this.nameField.setText(object.getName());
                this.idField.setText(object.getId());
                this.typeField.setText(object.getType().getId());
                this.basetypeField.setText(object.getBaseTypeId().toString());
                if (object instanceof Document) {
                    try {
                        this.versionLabelField.setText(((Document)object).getVersionLabel());
                    }
                    catch (Exception e) {
                        this.versionLabelField.setText("???");
                    }
                } else {
                    this.versionLabelField.setText("");
                }
                if (object instanceof FileableCmisObject) {
                    if (object instanceof Folder) {
                        this.paths.setList(Collections.singletonList(((Folder)object).getPath()));
                    } else {
                        this.paths.setList(Collections.singletonList(""));
                        final FileableCmisObject pathObject = (FileableCmisObject)object;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    List pathsList = pathObject.getPaths();
                                    if (pathsList == null || pathsList.size() == 0) {
                                        ObjectPanel.this.paths.setList(Collections.singletonList("(unfiled)"));
                                    } else {
                                        ObjectPanel.this.paths.setList(pathsList);
                                    }
                                }
                                catch (Exception e) {
                                    ObjectPanel.this.paths.setList(Collections.singletonList("(???)"));
                                }
                                ObjectPanel.this.revalidate();
                            }
                        });
                    }
                } else {
                    this.paths.setList(Collections.singletonList("(not filable)"));
                }
                String docUrl = this.getDocumentURL(object, this.model.getClientSession().getSession());
                if (docUrl != null) {
                    this.contentUrlField.setText(docUrl);
                } else {
                    this.contentUrlField.setText("(not available)");
                }
                if (object.getAllowableActions() != null) {
                    this.allowableActionsList.setList(object.getAllowableActions().getAllowableActions());
                } else {
                    this.allowableActionsList.setList(Collections.singletonList("(missing)"));
                }
                this.refreshButton.setEnabled(true);
            }
            catch (Exception e) {
                ClientHelper.showError(this, e);
            }
        }
        this.revalidate();
    }

    private void createGUI() {
        this.setupGUI();
        this.nameField = this.addLine("Name:", true);
        this.idField = this.addLine("Id:");
        this.typeField = this.addLine("Type:");
        this.basetypeField = this.addLine("Base Type:");
        this.versionLabelField = this.addLine("Version Label:");
        this.paths = this.addComponent("Paths:", new InfoPanel.InfoList());
        this.contentUrlField = this.addLink("Content URL:");
        this.allowableActionsList = this.addComponent("Allowable Actions:", new InfoPanel.InfoList());
        this.refreshButton = this.addComponent("", new JButton("Refresh"));
        this.refreshButton.setEnabled(false);
        this.refreshButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                    ObjectPanel.this.model.reloadObject();
                }
                catch (Exception ex) {
                    ClientHelper.showError(null, ex);
                }
                finally {
                    ObjectPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public String getDocumentURL(CmisObject document, Session session) {
        if (session.getBinding().getObjectService() instanceof LinkAccess) {
            return ((LinkAccess)session.getBinding().getObjectService()).loadContentLink(session.getRepositoryInfo().getId(), document.getId());
        }
        return null;
    }
}

