/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.details;

import java.awt.event.MouseEvent;
import java.util.Collection;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.workbench.PropertyEditorFrame;
import org.apache.chemistry.opencmis.workbench.details.AbstractDetailsTable;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public class PropertyTable
extends AbstractDetailsTable {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Id", "Type", "Value"};
    private static final int[] COLUMN_WIDTHS = new int[]{200, 200, 80, 300};

    public PropertyTable(ClientModel model) {
        this.init(model, COLUMN_NAMES, COLUMN_WIDTHS);
    }

    @Override
    public void doubleClickAction(MouseEvent e, int rowIndex) {
        AllowableActions aa = this.getObject().getAllowableActions();
        if (aa == null || aa.getAllowableActions() == null || aa.getAllowableActions().contains(Action.CAN_UPDATE_PROPERTIES)) {
            new PropertyEditorFrame(this.getClientModel(), this.getObject());
        }
    }

    @Override
    public int getDetailRowCount() {
        return this.getObject().getProperties().size();
    }

    @Override
    public Object getDetailValueAt(int rowIndex, int columnIndex) {
        Property property = (Property)this.getObject().getProperties().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return property.getDefinition().getDisplayName();
            }
            case 1: {
                return property.getId();
            }
            case 2: {
                return property.getDefinition().getPropertyType().value();
            }
            case 3: {
                return property.getValues();
            }
        }
        return null;
    }

    @Override
    public Class<?> getDetailColumClass(int columnIndex) {
        if (columnIndex == 3) {
            return Collection.class;
        }
        return super.getDetailColumClass(columnIndex);
    }
}

