/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.CapabilityChanges;
import org.apache.chemistry.opencmis.commons.enums.CapabilityQuery;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.MimeTypes;
import org.apache.chemistry.opencmis.workbench.model.ClientModelEvent;
import org.apache.chemistry.opencmis.workbench.model.ClientSession;
import org.apache.chemistry.opencmis.workbench.model.FolderListener;
import org.apache.chemistry.opencmis.workbench.model.ObjectListener;

public class ClientModel {
    private static final long OLD = 60000L;
    private ClientSession clientSession;
    private Folder currentFolder = null;
    private List<CmisObject> currentChildren = Collections.emptyList();
    private CmisObject currentObject = null;
    private final EventListenerList listenerList = new EventListenerList();

    public void addFolderListener(FolderListener listener) {
        this.listenerList.add(FolderListener.class, listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this.listenerList.remove(FolderListener.class, listener);
    }

    public void addObjectListener(ObjectListener listener) {
        this.listenerList.add(ObjectListener.class, listener);
    }

    public void removeObjectListener(ObjectListener listener) {
        this.listenerList.remove(ObjectListener.class, listener);
    }

    public synchronized void setClientSession(ClientSession clientSession) {
        this.clientSession = clientSession;
    }

    public synchronized ClientSession getClientSession() {
        return this.clientSession;
    }

    public synchronized RepositoryInfo getRepositoryInfo() throws Exception {
        Session session = this.clientSession.getSession();
        return session.getRepositoryInfo();
    }

    public synchronized String getRepositoryName() {
        try {
            return this.getRepositoryInfo().getName();
        }
        catch (Exception e) {
            return "?";
        }
    }

    public synchronized boolean supportsQuery() {
        try {
            RepositoryCapabilities cap = this.getRepositoryInfo().getCapabilities();
            if (cap == null) {
                return true;
            }
            return cap.getQueryCapability() != null && cap.getQueryCapability() != CapabilityQuery.NONE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean supportsChangeLog() {
        try {
            RepositoryCapabilities cap = this.getRepositoryInfo().getCapabilities();
            if (cap == null) {
                return true;
            }
            return cap.getChangesCapability() != null && cap.getChangesCapability() != CapabilityChanges.NONE;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void loadFolder(String folderId, boolean byPath) throws Exception {
        try {
            Session session = this.clientSession.getSession();
            CmisObject folderObject = null;
            folderObject = byPath ? session.getObjectByPath(folderId) : session.getObject(session.createObjectId(folderId));
            if (!(folderObject instanceof Folder)) {
                if (!(folderObject instanceof FileableCmisObject)) throw new Exception("The object is a relationship and not in a folder!");
                List parents = ((FileableCmisObject)folderObject).getParents();
                if (parents == null || parents.size() <= 0) throw new Exception("The object is not a folder and not in a folder!");
                folderObject = (CmisObject)parents.get(0);
            }
            ArrayList<CmisObject> children = new ArrayList<CmisObject>();
            ItemIterable iter = ((Folder)folderObject).getChildren(this.clientSession.getFolderOperationContext());
            for (CmisObject child : iter) {
                children.add(child);
            }
            this.setCurrentFolder((Folder)folderObject, children);
            return;
        }
        catch (Exception ex) {
            this.setCurrentFolder(null, new ArrayList<CmisObject>(0));
            throw ex;
        }
    }

    public synchronized void reloadFolder() throws Exception {
        this.loadFolder(this.currentFolder.getId(), false);
    }

    public synchronized void loadObject(String objectId) throws Exception {
        try {
            Session session = this.clientSession.getSession();
            CmisObject object = session.getObject(objectId, this.clientSession.getObjectOperationContext());
            object.refreshIfOld(60000L);
            this.setCurrentObject(object);
        }
        catch (Exception ex) {
            this.setCurrentObject(null);
            throw ex;
        }
    }

    public synchronized void reloadObject() throws Exception {
        if (this.currentObject == null) {
            return;
        }
        try {
            Session session = this.clientSession.getSession();
            CmisObject object = session.getObject((ObjectId)this.currentObject, this.clientSession.getObjectOperationContext());
            object.refresh();
            this.setCurrentObject(object);
        }
        catch (Exception ex) {
            this.setCurrentObject(null);
            throw ex;
        }
    }

    public synchronized ItemIterable<QueryResult> query(String q, boolean searchAllVersions, int maxHits) throws Exception {
        OperationContextImpl queryContext = new OperationContextImpl(null, false, false, false, IncludeRelationships.NONE, null, false, null, false, maxHits);
        Session session = this.clientSession.getSession();
        return session.query(q, searchAllVersions, (OperationContext)queryContext);
    }

    public synchronized List<Tree<ObjectType>> getTypeDescendants() throws Exception {
        Session session = this.clientSession.getSession();
        return session.getTypeDescendants(null, -1, true);
    }

    public ContentStream createContentStream(String filename) throws Exception {
        ContentStream content = null;
        if (filename != null && filename.length() > 0) {
            File file = new File(filename);
            FileInputStream stream = new FileInputStream(file);
            content = this.clientSession.getSession().getObjectFactory().createContentStream(file.getName(), file.length(), MimeTypes.getMIMEType((File)file), (InputStream)stream);
        }
        return content;
    }

    public synchronized void createDocument(String name, String type, String filename, VersioningState versioningState) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        ContentStream content = this.createContentStream(filename);
        this.clientSession.getSession().createDocument(properties, (ObjectId)this.currentFolder, content, versioningState, null, null, null);
    }

    public synchronized void createFolder(String name, String type) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", type);
        this.clientSession.getSession().createFolder(properties, (ObjectId)this.currentFolder, null, null, null);
    }

    public synchronized List<ObjectType> getCreateableTypes(String rootTypeId) {
        boolean isCreatable;
        ArrayList<ObjectType> result = new ArrayList<ObjectType>();
        List types = this.clientSession.getSession().getTypeDescendants(rootTypeId, -1, false);
        this.addType(types, result);
        ObjectType rootType = this.clientSession.getSession().getTypeDefinition(rootTypeId);
        boolean bl = isCreatable = rootType.isCreatable() == null ? true : rootType.isCreatable();
        if (isCreatable) {
            result.add(rootType);
        }
        Collections.sort(result, new Comparator<ObjectType>(){

            @Override
            public int compare(ObjectType ot1, ObjectType ot2) {
                return ot1.getDisplayName().compareTo(ot2.getDisplayName());
            }
        });
        return result;
    }

    private void addType(List<Tree<ObjectType>> types, List<ObjectType> resultList) {
        for (Tree<ObjectType> tt : types) {
            boolean isCreatable;
            if (tt.getItem() == null) continue;
            boolean bl = isCreatable = ((ObjectType)tt.getItem()).isCreatable() == null ? true : ((ObjectType)tt.getItem()).isCreatable();
            if (isCreatable) {
                resultList.add((ObjectType)tt.getItem());
            }
            this.addType(tt.getChildren(), resultList);
        }
    }

    public synchronized Folder getCurrentFolder() {
        return this.currentFolder;
    }

    public synchronized List<CmisObject> getCurrentChildren() {
        return this.currentChildren;
    }

    public synchronized CmisObject getFromCurrentChildren(String id) {
        if (this.currentChildren == null || this.currentChildren.isEmpty()) {
            return null;
        }
        for (CmisObject o : this.currentChildren) {
            if (!o.getId().equals(id)) continue;
            return o;
        }
        return null;
    }

    private synchronized void setCurrentFolder(Folder folder, List<CmisObject> children) {
        this.currentFolder = folder;
        this.currentChildren = children;
        for (FolderListener fl : (FolderListener[])this.listenerList.getListeners(FolderListener.class)) {
            fl.folderLoaded(new ClientModelEvent(this));
        }
    }

    public synchronized CmisObject getCurrentObject() {
        return this.currentObject;
    }

    private synchronized void setCurrentObject(CmisObject object) {
        this.currentObject = object;
        for (ObjectListener ol : (ObjectListener[])this.listenerList.getListeners(ObjectListener.class)) {
            ol.objectLoaded(new ClientModelEvent(this));
        }
    }
}

