/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.model;

import java.net.Authenticator;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.workbench.model.ClientOperationContext;

public class ClientSession {
    public static final String WORKBENCH_PREFIX = "cmis.workbench.";
    public static final String OBJECT_PREFIX = "cmis.workbench.object.";
    public static final String FOLDER_PREFIX = "cmis.workbench.folder.";
    public static final String VERSION_PREFIX = "cmis.workbench.version.";
    public static final String ACCEPT_SELF_SIGNED_CERTIFICATES = "cmis.workbench.acceptSelfSignedCertificates";
    private static final Set<String> FOLDER_PROPERTY_SET = new HashSet<String>();
    private static final Set<String> VERSION_PROPERTY_SET;
    private Map<String, String> sessionParameters;
    private List<Repository> repositories;
    private Session session;
    private OperationContext objectOperationContext;
    private OperationContext folderOperationContext;
    private OperationContext versionOperationContext;

    public ClientSession(Map<String, String> sessionParameters) {
        if (sessionParameters == null) {
            throw new IllegalArgumentException("Parameters must not be null!");
        }
        this.connect(sessionParameters);
    }

    public static Map<String, String> createSessionParameters(String url, BindingType binding, String username, String password, Authentication authentication, boolean compression) {
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        if (binding == BindingType.WEBSERVICES) {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.WEBSERVICES.value());
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RepositoryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.NavigationService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ObjectService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.VersioningService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.DiscoveryService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.MultiFilingService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.RelationshipService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.ACLService", url);
            parameters.put("org.apache.chemistry.opencmis.binding.webservices.PolicyService", url);
        } else {
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", url);
        }
        switch (authentication) {
            case STANDARD: {
                parameters.put("org.apache.chemistry.opencmis.user", username);
                parameters.put("org.apache.chemistry.opencmis.password", password);
                break;
            }
            case NTLM: {
                parameters.put("org.apache.chemistry.opencmis.user", username);
                parameters.put("org.apache.chemistry.opencmis.password", password);
                parameters.put("org.apache.chemistry.opencmis.binding.auth.classname", "org.apache.chemistry.opencmis.client.bindings.spi.NTLMAuthenticationProvider");
            }
        }
        if (compression) {
            parameters.put("org.apache.chemistry.opencmis.binding.compression", "true");
        }
        Properties sysProps = System.getProperties();
        for (String key : sysProps.stringPropertyNames()) {
            if (!key.startsWith(WORKBENCH_PREFIX)) continue;
            parameters.put(key, sysProps.getProperty(key));
        }
        return parameters;
    }

    private void connect(Map<String, String> sessionParameters) {
        this.sessionParameters = sessionParameters;
        Authenticator.setDefault(new Authenticator(){});
        if (Boolean.parseBoolean(sessionParameters.get(ACCEPT_SELF_SIGNED_CERTIFICATES))) {
            this.acceptSelfSignedCertificates();
        }
        this.repositories = SessionFactoryImpl.newInstance().getRepositories(sessionParameters);
    }

    public List<Repository> getRepositories() {
        return this.repositories;
    }

    public Session createSession(int index) {
        this.session = this.repositories.get(index).createSession();
        this.createOperationContexts();
        return this.getSession();
    }

    public Session getSession() {
        return this.session;
    }

    public Map<String, String> getSessionParameters() {
        return Collections.unmodifiableMap(this.sessionParameters);
    }

    public OperationContext getObjectOperationContext() {
        return this.objectOperationContext;
    }

    public OperationContext getFolderOperationContext() {
        return this.folderOperationContext;
    }

    public OperationContext geVersionOperationContext() {
        return this.versionOperationContext;
    }

    private void createOperationContexts() {
        PropertyDefinition propDef;
        StringBuilder filter;
        ObjectType type;
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "filter", "*");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeAcls", "true");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeAllowableActions", "true");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includePolicies", "true");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.BOTH.value());
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "renditionFilter", "*");
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "orderBy", null);
        this.setDefault(OBJECT_PREFIX, this.sessionParameters, "maxItemsPerPage", "1000");
        this.objectOperationContext = new ClientOperationContext(OBJECT_PREFIX, this.sessionParameters);
        if (!this.sessionParameters.containsKey("cmis.workbench.folder.filter")) {
            type = this.session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            filter = new StringBuilder();
            for (String propId : FOLDER_PROPERTY_SET) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(",");
                }
                filter.append(propDef.getQueryName());
            }
            this.sessionParameters.put("cmis.workbench.folder.filter", filter.toString());
        }
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeAcls", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeAllowableActions", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includePolicies", "false");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.NONE.value());
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "renditionFilter", "cmis:none");
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "orderBy", null);
        this.setDefault(FOLDER_PREFIX, this.sessionParameters, "maxItemsPerPage", "10000");
        this.folderOperationContext = new ClientOperationContext(FOLDER_PREFIX, this.sessionParameters);
        if (!this.sessionParameters.containsKey("cmis.workbench.version.filter")) {
            type = this.session.getTypeDefinition(BaseTypeId.CMIS_DOCUMENT.value());
            filter = new StringBuilder();
            for (String propId : VERSION_PROPERTY_SET) {
                propDef = (PropertyDefinition)type.getPropertyDefinitions().get(propId);
                if (propDef == null) continue;
                if (filter.length() > 0) {
                    filter.append(",");
                }
                filter.append(propDef.getQueryName());
            }
            this.sessionParameters.put("cmis.workbench.version.filter", filter.toString());
        }
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeAcls", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeAllowableActions", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includePolicies", "false");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "includeRelationships", IncludeRelationships.NONE.value());
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "renditionFilter", "cmis:none");
        this.setDefault(VERSION_PREFIX, this.sessionParameters, "maxItemsPerPage", "10000");
        this.versionOperationContext = new ClientOperationContext(VERSION_PREFIX, this.sessionParameters);
    }

    private void setDefault(String prefix, Map<String, String> map, String key, String value) {
        if (!map.containsKey(prefix + key)) {
            map.put(prefix + key, value);
        }
    }

    private void acceptSelfSignedCertificates() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        FOLDER_PROPERTY_SET.add("cmis:objectId");
        FOLDER_PROPERTY_SET.add("cmis:objectTypeId");
        FOLDER_PROPERTY_SET.add("cmis:name");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamMimeType");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamLength");
        FOLDER_PROPERTY_SET.add("cmis:contentStreamFileName");
        FOLDER_PROPERTY_SET.add("cmis:createdBy");
        FOLDER_PROPERTY_SET.add("cmis:creationDate");
        FOLDER_PROPERTY_SET.add("cmis:lastModifiedBy");
        FOLDER_PROPERTY_SET.add("cmis:lastModificationDate");
        VERSION_PROPERTY_SET = new HashSet<String>();
        VERSION_PROPERTY_SET.add("cmis:objectId");
        VERSION_PROPERTY_SET.add("cmis:objectTypeId");
        VERSION_PROPERTY_SET.add("cmis:name");
        VERSION_PROPERTY_SET.add("cmis:versionLabel");
        VERSION_PROPERTY_SET.add("cmis:isLatestVersion");
        VERSION_PROPERTY_SET.add("cmis:isMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:isLatestMajorVersion");
        VERSION_PROPERTY_SET.add("cmis:contentStreamMimeType");
        VERSION_PROPERTY_SET.add("cmis:contentStreamLength");
        VERSION_PROPERTY_SET.add("cmis:contentStreamFileName");
    }

    public static enum Authentication {
        NONE,
        STANDARD,
        NTLM;

    }
}

