/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.Component;
import java.util.Collection;
import java.util.GregorianCalendar;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.workbench.ClientHelper;

public class CollectionRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        int height = (int)this.getPreferredSize().getHeight();
        if (height > this.getFontMetrics(this.getFont()).getHeight() + this.getInsets().bottom + this.getInsets().top && table.getRowHeight(row) != height) {
            table.setRowHeight(row, height);
        }
        return comp;
    }

    @Override
    protected void setValue(Object value) {
        Collection col = (Collection)value;
        if (col == null || col.isEmpty()) {
            super.setValue("");
            return;
        }
        StringBuilder sb = new StringBuilder("<html>");
        for (Object o : col) {
            sb.append("<span>");
            if (o == null) {
                sb.append("<i>null</i>");
            } else if (o instanceof GregorianCalendar) {
                sb.append(ClientHelper.getDateString((GregorianCalendar)o));
            } else if (o instanceof Choice) {
                sb.append(((Choice)o).getValue());
            } else {
                sb.append(o.toString());
            }
            sb.append("</span><br/>");
        }
        super.setValue(sb.toString());
    }
}

