/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.workbench.model.ClientModel;

public abstract class CreateDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ClientModel model;
    private final JPanel panel;

    public CreateDialog(Frame owner, String title, ClientModel model) {
        super(owner, title, true);
        this.model = model;
        this.setLayout(new BorderLayout());
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.panel, "Center");
    }

    protected ClientModel getClientModel() {
        return this.model;
    }

    protected void createRow(String label, JComponent comp, int row) {
        JLabel textLabel = new JLabel(label);
        textLabel.setLabelFor(comp);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 21;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = row;
        this.panel.add((Component)textLabel, c);
        c.gridx = 1;
        this.panel.add((Component)comp, c);
    }

    public void showDialog() {
        this.panel.invalidate();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    protected Object[] getTypes(String rootTypeId) {
        List<ObjectType> types = this.model.getCreateableTypes(rootTypeId);
        Object[] result = new Object[types.size()];
        int i = 0;
        for (final ObjectType type : types) {
            result[i] = new ObjectTypeItem(){

                @Override
                public ObjectType getObjectType() {
                    return type;
                }

                public String toString() {
                    return type.getDisplayName() + " (" + type.getId() + ")";
                }
            };
            ++i;
        }
        return result;
    }

    public static interface ObjectTypeItem {
        public ObjectType getObjectType();
    }
}

