/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.workbench.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.chemistry.opencmis.workbench.ClientHelper;

public abstract class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel gridPanel;
    private GridBagConstraints gbc;
    private Font boldFont;

    protected void setupGUI() {
        this.setLayout(new FlowLayout(0));
        this.setBackground(Color.WHITE);
        this.gridPanel = new JPanel(new GridBagLayout());
        this.gridPanel.setBackground(Color.WHITE);
        this.add(this.gridPanel);
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 1;
        this.gbc.gridy = 0;
        this.gbc.insets = new Insets(3, 3, 3, 3);
        Font labelFont = UIManager.getFont("Label.font");
        this.boldFont = labelFont.deriveFont(1, labelFont.getSize2D() * 1.2f);
    }

    protected JTextField addLine(String label) {
        return this.addLine(label, false);
    }

    protected JTextField addLine(String label, boolean bold) {
        JTextField textField = new JTextField();
        textField.setEditable(false);
        textField.setBorder(BorderFactory.createEmptyBorder());
        if (bold) {
            textField.setFont(this.boldFont);
        }
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(textField);
        if (bold) {
            textLable.setFont(this.boldFont);
        }
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)textField, this.gbc);
        return textField;
    }

    protected JTextField addLink(String label) {
        final JTextField textField = this.addLine(label, false);
        if (Desktop.isDesktopSupported()) {
            textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String uri = textField.getText().toLowerCase();
                    if (uri.startsWith("http://") || uri.startsWith("https://")) {
                        textField.setForeground(Color.BLUE);
                        textField.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        textField.setForeground(UIManager.getColor("textForeground"));
                        textField.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            textField.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    String uri;
                    if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 1 && ((uri = textField.getText().toLowerCase()).startsWith("http://") || uri.startsWith("https://"))) {
                        try {
                            Desktop.getDesktop().browse(new URI(textField.getText()));
                        }
                        catch (Exception ex) {
                            ClientHelper.showError(InfoPanel.this, ex);
                        }
                    }
                }
            });
        }
        return textField;
    }

    protected JCheckBox addCheckBox(String label) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setEnabled(false);
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(checkBox);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add((Component)checkBox, this.gbc);
        return checkBox;
    }

    protected <T extends JComponent> T addComponent(String label, T comp) {
        JLabel textLable = new JLabel(label);
        textLable.setLabelFor(comp);
        ++this.gbc.gridy;
        this.gbc.gridx = 0;
        this.gbc.anchor = 768;
        this.gridPanel.add((Component)textLable, this.gbc);
        this.gbc.gridx = 1;
        this.gbc.anchor = 512;
        this.gridPanel.add(comp, this.gbc);
        return comp;
    }

    public static class InfoList
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public InfoList() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBackground(Color.WHITE);
        }

        public void clear() {
            this.removeAll();
        }

        public void setList(Collection<?> list) {
            this.clear();
            if (list == null || list.size() == 0) {
                return;
            }
            for (Object o : list) {
                JTextField textField = new JTextField(o == null ? "" : o.toString());
                textField.setEditable(false);
                textField.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
                this.add(textField);
            }
        }
    }
}

