/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.callstack.CallFrame;
import org.apache.cocoon.callstack.CallStack;
import org.apache.cocoon.callstack.environment.CallFrameHelper;

public class CallStackHelper {
    public static final String SUPER_CALL = "super";

    public static void enterServlet(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        CallStackHelper.enterServlet(context, request, response, false);
    }

    public static void enterSuperServlet(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException {
        CallStackHelper.enterServlet(context, request, response, true);
    }

    private static void enterServlet(ServletContext context, HttpServletRequest request, HttpServletResponse response, boolean superCall) throws ServletException {
        if (null == context) {
            throw new ServletException("The context is not set.");
        }
        if (null == request) {
            throw new ServletException("The request is not set.");
        }
        if (null == response) {
            throw new ServletException("The response is not set.");
        }
        CallStack.enter();
        CallStack.getCurrentFrame().setAttribute(SUPER_CALL, superCall);
        CallFrameHelper.setContext(context);
        CallFrameHelper.setRequest(request);
        CallFrameHelper.setResponse(response);
    }

    public static void leaveServlet() {
        CallStack.leave();
    }

    public static ServletContext getBaseServletContext() {
        for (int i = CallStack.size() - 1; i >= 0; --i) {
            CallFrame frame = CallStack.frameAt(i);
            if (!frame.hasAttribute(SUPER_CALL) || ((Boolean)frame.getAttribute(SUPER_CALL)).booleanValue()) continue;
            return (ServletContext)frame.getAttribute("context");
        }
        return null;
    }

    public static ServletContext getCurrentServletContext() {
        return CallFrameHelper.getContext();
    }
}

