/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servletservice;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;

public class DynamicProxyRequestHandler
implements InvocationHandler {
    private final HttpServletRequest wrapped;
    private final String mountPath;
    private static final Method getContextPathMethod = DynamicProxyRequestHandler.getHttpServletRequestMethod("getContextPath");
    private static final Method getServletPathMethod = DynamicProxyRequestHandler.getHttpServletRequestMethod("getServletPath");
    private static final Method getPathInfoMethod = DynamicProxyRequestHandler.getHttpServletRequestMethod("getPathInfo");

    private static Method getHttpServletRequestMethod(String name) {
        Class[] paramTypes = new Class[]{};
        try {
            return HttpServletRequest.class.getMethod(name, paramTypes);
        }
        catch (SecurityException e) {
            throw new RuntimeException("could not get method: " + name + " from class: " + HttpServletRequest.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("could not get method: " + name + " from class: " + HttpServletRequest.class);
        }
    }

    public DynamicProxyRequestHandler(HttpServletRequest req, String mountPath) {
        this.wrapped = req;
        this.mountPath = mountPath;
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        if (method.equals(getContextPathMethod)) {
            return this.wrapped.getContextPath() + this.wrapped.getServletPath();
        }
        if (method.equals(getServletPathMethod)) {
            return this.mountPath;
        }
        if (method.equals(getPathInfoMethod)) {
            String pathInfo = this.wrapped.getPathInfo().substring(this.mountPath.length());
            return pathInfo.length() == 0 ? null : pathInfo;
        }
        return method.invoke((Object)this.wrapped, arguments);
    }
}

