/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.caching;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.cocoon.pipeline.caching.AbstractCacheValue;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObjectCacheValue
extends AbstractCacheValue {
    private static final long serialVersionUID = 1L;
    private final Object value;
    private final Log logger = LogFactory.getLog(this.getClass());

    public ObjectCacheValue(Object value, CacheKey cacheKey) {
        super(cacheKey);
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("Cannot set the content of ObjectCacheValue to OutputStream.");
    }

    public double size() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(this.value);
            objectOut.flush();
            objectOut.close();
        }
        catch (IOException e) {
            this.logger.error((Object)("Some thing goes wrong during calculating size of: " + this.getCacheKey()), (Throwable)e);
            return -1.0;
        }
        return byteOut.toByteArray().length;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Cannot write the content of ObjectCacheValue to OutputStream.");
    }
}

