/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.pipeline.caching.CacheKey;
import org.apache.cocoon.pipeline.caching.SimpleCacheKey;
import org.apache.cocoon.pipeline.component.CachingPipelineComponent;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.component.LinkRewriterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLinkRewriterTransformer
extends AbstractSAXTransformer
implements CachingPipelineComponent {
    protected static final String ALL_NAMESPACES = "*";
    protected static final String EMPTY_NAMESPACE = "";
    private static final String ELEMENT_PREFIX = "element";
    protected static final Log LOG = LogFactory.getLog(AbstractLinkRewriterTransformer.class);
    private final Map<Element, Set<Element>> elements = new HashMap<Element, Set<Element>>();

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setup(configuration);
    }

    public void setup(Map<String, Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (!parameter.getKey().startsWith(ELEMENT_PREFIX)) continue;
            String[] split = ((String)parameter.getValue()).split(" ");
            if (split.length == 2) {
                this.addElement(split[0], split[1]);
                continue;
            }
            if (split.length == 4) {
                this.addElement(split[0], split[1], split[2], split[3]);
                continue;
            }
            LOG.error((Object)("Invalid element as parameter, ignoring: " + parameter.getValue()));
        }
    }

    @Override
    public final void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing element (namespace=" + uri + ", name=" + localName + ")"));
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeNS = atts.getURI(i);
            String attributeName = atts.getLocalName(i);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Processing attribute ( namepsace=" + attributeNS + ", name=" + attributeName + ")"));
            }
            if (!this.contains(uri, localName, attributeNS, attributeName)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Element has attributes to rewrite");
            }
            String attributeValue = atts.getValue(i);
            atts = new AttributesImpl(atts);
            try {
                String rewrite = this.rewrite(uri, name, attributeNS, attributeName, attributeValue);
                ((AttributesImpl)atts).setValue(i, rewrite);
                continue;
            }
            catch (LinkRewriterException e) {
                LOG.error((Object)("An error occurred while rewriting link '" + attributeValue + "' (" + name + "/@" + attributeName + ")"), (Throwable)((Object)e));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Finished processing (namespace=" + uri + ", name=" + localName + ")"));
        }
        super.startElement(uri, localName, name, atts);
    }

    public final void addElement(String elementName, String attributeName) {
        this.addElement(ALL_NAMESPACES, elementName, ALL_NAMESPACES, attributeName);
    }

    public final void addElement(String elementNS, String elementName, String attributeNS, String attributeName) {
        Set<Object> attributes;
        if (elementName == null) {
            throw new IllegalArgumentException("Parameter 'elementName' must not be null");
        }
        Element key = new Element(elementNS == null ? EMPTY_NAMESPACE : elementNS, elementName);
        if (attributeName == null) {
            throw new IllegalArgumentException("Parameter 'attributeName' must not be null");
        }
        if (this.elements.containsKey(key)) {
            attributes = this.elements.get(key);
        } else {
            attributes = new HashSet();
            this.elements.put(key, attributes);
        }
        attributes.add(new Element(attributeNS == null ? EMPTY_NAMESPACE : attributeNS, attributeName));
    }

    protected abstract String rewrite(String var1, String var2, String var3, String var4, String var5) throws LinkRewriterException;

    private boolean contains(String elementNamespace, String elementName, String atributeNamespace, String attributeName) {
        Element element = new Element(elementNamespace, elementName);
        return this.elements.containsKey(element) && this.elements.get(element).contains(new Element(atributeNamespace, attributeName));
    }

    public final CacheKey constructCacheKey() {
        return new SimpleCacheKey();
    }

    private final class Element {
        private final String namespace;
        private final String name;

        public Element(String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int initialNonZeroOddNumber = 97;
            int multiplierNonZeroOddNumber = 7;
            return 679 + this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Element other = (Element)obj;
            if (!(AbstractLinkRewriterTransformer.ALL_NAMESPACES.equals(this.namespace) || AbstractLinkRewriterTransformer.ALL_NAMESPACES.equals(other.getNamespace()) || this.namespace.equals(other.getNamespace()))) {
                return false;
            }
            return this.name.equals(other.getName());
        }

        public String toString() {
            return "{ namespace='" + this.namespace + "', name='" + this.name + "' }";
        }
    }
}

