/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sax.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.SetupException;
import org.apache.cocoon.sax.AbstractSAXTransformer;
import org.apache.cocoon.sax.component.XMLSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogAsXMLTransformer
extends AbstractSAXTransformer {
    private static final String LOG_FILE = "logfile";
    private static final Log LOG = LogFactory.getLog(LogAsXMLTransformer.class);
    private final transient XMLSerializer xmlSerializer = XMLSerializer.createXMLSerializer();
    private transient OutputStream outputStream;

    public LogAsXMLTransformer() {
        this(null);
    }

    public LogAsXMLTransformer(File logFile) {
        if (logFile == null) {
            this.init(System.out);
        } else {
            try {
                this.init(new FileOutputStream(logFile));
            }
            catch (FileNotFoundException e) {
                throw new SetupException("Impossible to create an XML log file '" + logFile + "'", (Throwable)e);
            }
        }
    }

    private void init(OutputStream outputStream) {
        this.xmlSerializer.setup(new HashMap<String, Object>());
        this.xmlSerializer.setOutputStream(outputStream);
        this.xmlSerializer.setIndent(true);
        this.outputStream = outputStream;
    }

    public void setConfiguration(Map<String, ? extends Object> configuration) {
        this.setup(configuration);
    }

    public void setup(Map<String, Object> parameters) {
        if (parameters == null || !parameters.containsKey(LOG_FILE)) {
            return;
        }
        String logFileName = String.valueOf(parameters.get(LOG_FILE));
        if (logFileName != null) {
            File logFile = new File(logFileName);
            try {
                FileOutputStream os = new FileOutputStream(logFile);
                this.init(os);
            }
            catch (FileNotFoundException e) {
                throw new SetupException("Impossible to open XML log file '" + logFile + "'", (Throwable)e);
            }
        }
    }

    public void finish() {
        this.xmlSerializer.finish();
        if (this.outputStream != null) {
            try {
                if (System.out.equals(this.outputStream)) {
                    this.outputStream.flush();
                } else {
                    this.outputStream.close();
                }
            }
            catch (IOException e) {
                LOG.debug((Object)"Impossible to close the log writer", (Throwable)e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.xmlSerializer.characters(ch, start, length);
        super.characters(ch, start, length);
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        this.xmlSerializer.comment(ch, start, length);
        super.comment(ch, start, length);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.xmlSerializer.endCDATA();
        super.endCDATA();
    }

    @Override
    public void endDocument() throws SAXException {
        this.xmlSerializer.endDocument();
        super.endDocument();
    }

    @Override
    public void endDTD() throws SAXException {
        this.xmlSerializer.endDTD();
        super.endDTD();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.xmlSerializer.endElement(uri, localName, name);
        super.endElement(uri, localName, name);
    }

    @Override
    public void endEntity(String name) throws SAXException {
        this.xmlSerializer.endEntity(name);
        super.endEntity(name);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.xmlSerializer.endPrefixMapping(prefix);
        super.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.xmlSerializer.ignorableWhitespace(ch, start, length);
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.xmlSerializer.processingInstruction(target, data);
        super.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.xmlSerializer.setDocumentLocator(locator);
        super.setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.xmlSerializer.skippedEntity(name);
        super.skippedEntity(name);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.xmlSerializer.startCDATA();
        super.startCDATA();
    }

    @Override
    public void startDocument() throws SAXException {
        this.xmlSerializer.startDocument();
        super.startDocument();
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.xmlSerializer.startDTD(name, publicId, systemId);
        super.startDTD(name, publicId, systemId);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.xmlSerializer.startElement(uri, localName, name, atts);
        super.startElement(uri, localName, name, atts);
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.xmlSerializer.startEntity(name);
        super.startEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.xmlSerializer.startPrefixMapping(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }
}

